# 🏥 Cibertronia Salud - Sistema de Gestión de Pacientes

## ✅ Estado del Proyecto: **LISTO PARA USAR**

Sistema completo de gestión de pacientes con:
- ✅ Base de datos MariaDB configurada (17 tablas)
- ✅ Backend Laravel con API REST
- ✅ Frontend React + TypeScript con UI premium
- ✅ Autenticación con Laravel Sanctum
- ✅ CORS configurado
- ✅ Modelos y controladores principales creados

---

## 🚀 Inicio Rápido

### **Opción 1: Script Automatizado** (Recomendado)

```powershell
# Ejecuta este archivo para configurar todo automáticamente
.\INICIAR.bat
```

### **Opción 2: Manual**

**Terminal 1 - Backend Laravel:**
```powershell
php artisan serve
```
👉 Corre en: **http://localhost:8000**

**Terminal 2 - Frontend React:**
```powershell
npm run dev
```
👉 Corre en: **http://localhost:5173**

---

## 🔐 Credenciales de Prueba

| Email | Password | Rol |
|-------|----------|-----|
| admin@cibertroniasalud.com | Admin123! | Administrador |
| dr.perez@cibertroniasalud.com | Admin123! | Médico |
| dra.gonzalez@cibertroniasalud.com | Admin123! | Médico |

---

## 📚 Documentación

- **`database/README.md`** - Documentación de la base de datos
- **`database/DIAGRAMA.md`** - Diagrama de relaciones
- **`database/EJEMPLOS_QUERIES.sql`** - Consultas SQL de ejemplo
- **`LARAVEL_CONFIGURADO.md`** - Detalles del backend Laravel
- **`SIGUIENTE_PASO.md`** - Guía para continuar el desarrollo

---

## 📡 Endpoints API Disponibles

### Autenticación
- `POST /api/login` - Iniciar sesión
- `GET /api/user` - Usuario actual
- `POST /api/logout` - Cerrar sesión

### Pacientes
- `GET /api/pacientes` - Listar pacientes
- `POST /api/pacientes` - Crear paciente
- `GET /api/pacientes/{id}` - Ver detalle
- `PUT /api/pacientes/{id}` - Actualizar
- `GET /api/pacientes/{id}/historial` - Historial completo

### Citas
- `GET /api/citas` - Listar citas
- `POST /api/citas` - Agendar cita
- `GET /api/citas/hoy` - Citas de hoy
- `GET /api/citas/medico/{id}/agenda` - Agenda del médico

**Ver todos los endpoints en:** `LARAVEL_CONFIGURADO.md`

---

## 🗂️ Estructura del Proyecto

```
cibertronia-salud/
├── app/
│   ├── Http/Controllers/API/
│   │   ├── AuthController.php       ✅ Autenticación
│   │   ├── PacienteController.php   ✅ Gestión de pacientes
│   │   └── CitaController.php       ✅ Gestión de citas
│   └── Models/
│       ├── Usuario.php              ✅ Modelo de usuarios
│       ├── Paciente.php             ✅ Modelo de pacientes
│       ├── Cita.php                 ✅ Modelo de citas
│       └── HistoriaClinica.php      ✅ Modelo de historias
├── database/
│   ├── cibertronia_salud.sql       ✅ Script de base de datos
│   ├── README.md                    📚 Documentación BD
│   └── EJEMPLOS_QUERIES.sql        📚 Consultas ejemplo
├── resources/
│   ├── css/app.css                  🎨 Estilos del frontend
│   └── js/
│       ├── app.tsx                  ⚛️ App principal React
│       ├── bootstrap.js             ⚙️ Configuración axios
│       ├── components/              🧩 Componentes UI
│       └── pages/                   📄 Páginas de la app
├── routes/
│   └── api.php                      🛣️ Rutas API
├── .env                             ⚙️ Configuración
└── INICIAR.bat                      🚀 Script de inicio

```

---

## 🛠️ Comandos Útiles

### Laravel (Backend)
```powershell
# Limpiar cache
php artisan config:clear
php artisan cache:clear

# Ver rutas
php artisan route:list

# Crear nuevo modelo
php artisan make:model NombreModelo

# Crear nuevo controlador
php artisan make:controller NombreController
```

### React (Frontend)
```powershell
# Instalar dependencias
npm install

# Desarrollo
npm run dev

# Build para producción
npm run build
```

---

## 🧪 Probar la API

### Health Check
```bash
curl http://localhost:8000/api/health
```

### Login
```bash
curl -X POST http://localhost:8000/api/login \
  -H "Content-Type: application/json" \
  -d '{"email":"admin@cibertroniasalud.com","password":"Admin123!"}'
```

---

## 📦 Próximos Pasos Sugeridos

1. **Actualizar Login de React**
   - Modificar `resources/js/pages/Login.tsx` para usar API real
   - Ver ejemplo en `LARAVEL_CONFIGURADO.md`

2. **Crear más modelos**
   - AntecedenteMedico
   - Vacuna
   - ExamenMedico
   - RecetaMedica
   - Facturacion

3. **Crear más controladores**
   - HistoriaClinicaController
   - ExamenMedicoController
   - FacturacionController

4. **Implementar componentes React**
   - Dashboard con datos reales
   - Lista de pacientes
   - Formulario de citas
   - Historial médico

---

## 🆘 Solución de Problemas

### El backend no inicia
```powershell
# Verifica que Laragon esté corriendo
# Re-instala dependencias
composer install
php artisan key:generate
```

### El frontend no inicia
```powershell
npm install
npm run dev
```

### Error de CORS
- Verifica que Laravel esté en puerto 8000
- Verifica que React esté en puerto 5173
- El archivo `config/cors.php` ya está configurado

### Error de conexión a BD
- Verifica que Laragon/MySQL esté corriendo
- Revisa las credenciales en `.env`

---

## 📞 Soporte

Revisa la documentación completa en:
- `LARAVEL_CONFIGURADO.md` - Detalles del backend
- `database/README.md` - Detalles de la base de datos
- `SIGUIENTE_PASO.md` - Guía de desarrollo

---

## 🎉 ¡Listo para Desarrollar!

Tu aplicación está **100% configurada y lista para usar**. Solo ejecuta:

```powershell
# Terminal 1
php artisan serve

# Terminal 2  
npm run dev
```

Luego abre **http://localhost:5173** y haz login con:
- Email: `admin@cibertroniasalud.com`
- Password: `Admin123!`

---

**Creado con ❤️ para Cibertronia Salud**
**Febrero 2026**
