<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\HistoriaClinica;
use Carbon\Carbon;

class AuditoriaHistoriaClinica
{
    public function handle(Request $request, Closure $next)
    {
        // Solo interceptar las modificaciones (PUT, PATCH, DELETE)
        if (in_array($request->method(), ['PUT', 'PATCH', 'DELETE'])) {
            $id = $request->route('historias_clinica'); // Asumiendo que esta en apiResource como historias-clinicas
            // Alias si la ruta usa otro param
            if (!$id) $id = $request->route('id');

            if ($id) {
                $historia = HistoriaClinica::find($id);
                if ($historia) {
                    $creacion = Carbon::parse($historia->fecha_creacion);
                    // Regla de oro médica: no se alteran historias después de 24 horas
                    if (now()->diffInHours($creacion) > 24) {
                        
                        // Solo permitir con nota aclaratoria (en el body 'nota_aclaratoria' para PUT/PATCH)
                        if ($request->method() !== 'DELETE' && $request->has('nota_aclaratoria') && strlen($request->nota_aclaratoria) > 10) {
                            // Marcar que fue editada luego de 24 hs
                            $historia->bloqueada_para_edicion = true;
                            $historia->save();
                        } else {
                            return response()->json([
                                'success' => false,
                                'message' => 'BLOQUEO DE SEGURIDAD: Han pasado más de 24 horas desde la creación de esta Historia Clínica. Ya no puede ser editada directamente o borrada. Debe proporcionar una "nota_aclaratoria" obligatoria si desea anexar una corrección.',
                                'error_code' => 'CLINICAL_RECORD_LOCKED'
                            ], 403);
                        }
                    }
                }
            }
        }

        return $next($request);
    }
}
