<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        // Para APIs, no redirigir - devolver null para que lance una excepción de autenticación
        if ($request->is('api/*')) {
            return null;
        }

        return route('login');
    }
}
