<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\PacienteSesion;
use App\Models\PacienteUsuario;

class AuthenticatePaciente
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json([
                'success' => false,
                'message' => 'Token no proporcionado',
            ], 401);
        }

        // Buscar sesión por token
        $sesion = PacienteSesion::with('pacienteUsuario.paciente')
            ->where('token', $token)
            ->first();

        if (!$sesion) {
            return response()->json([
                'success' => false,
                'message' => 'Token inválido',
            ], 401);
        }

        // Verificar si la sesión está expirada
        if (!$sesion->estaActiva()) {
            $sesion->delete();
            return response()->json([
                'success' => false,
                'message' => 'Sesión expirada',
            ], 401);
        }

        // Verificar que el usuario esté activo
        $pacienteUsuario = $sesion->pacienteUsuario;

        if (!$pacienteUsuario->estaActivo()) {
            return response()->json([
                'success' => false,
                'message' => 'Usuario inactivo o bloqueado',
            ], 403);
        }

        // Extender la sesión (renovar por 24 horas más)
        $sesion->extender();

        // Agregar usuario al request
        $request->setUserResolver(function () use ($pacienteUsuario) {
            return $pacienteUsuario;
        });

        return $next($request);
    }
}
