<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Paciente;

class AuthenticatePacienteSimple
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();
        $pacienteId = $request->header('X-Paciente-Id');

        if (!$token || !$pacienteId) {
            return response()->json([
                'success' => false,
                'message' => 'No autenticado',
            ], 401);
        }

        // Verificar que el token comience con 'patient_'
        if (!str_starts_with($token, 'patient_')) {
            return response()->json([
                'success' => false,
                'message' => 'Token inválido',
            ], 401);
        }

        // Buscar paciente
        $paciente = Paciente::find($pacienteId);

        if (!$paciente || $paciente->estado !== 'activo') {
            return response()->json([
                'success' => false,
                'message' => 'Paciente no encontrado o inactivo',
            ], 403);
        }

        // Agregar paciente al request
        $request->setUserResolver(function () use ($paciente) {
            return $paciente;
        });

        return $next($request);
    }
}
