<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class ForceSanctumAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json(['message' => 'Unauthenticated. No token provided.'], 401);
        }

        $model = PersonalAccessToken::findToken($token);

        if (!$model || !$model->tokenable) {
            return response()->json(['message' => 'Unauthenticated. Invalid token.'], 401);
        }

        $user = $model->tokenable;

        if (method_exists($user, 'withAccessToken')) {
            $user = $user->withAccessToken($model);
        }

        Auth::guard('web')->setUser($user);

        $request->setUserResolver(function () use ($user) {
            return $user;
        });
        
        $model->forceFill(['last_used_at' => now()])->save();
        
        return $next($request);
    }
}
