<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cie10Catalog extends Model
{
    use HasFactory;

    protected $table = 'cie10_catalog';

    protected $fillable = [
        'codigo',
        'descripcion',
        'categoria',
        'subcategoria',
        'frecuencia_uso',
        'activo'
    ];

    protected $casts = [
        'activo' => 'boolean',
        'frecuencia_uso' => 'integer'
    ];

    // Scopes para búsqueda eficiente
    public function scopeBuscar($query, $termino)
    {
        return $query->where('codigo', 'like', "$termino%")
                     ->orWhere('descripcion', 'like', "%$termino%");
    }

    public function scopePopulares($query, $limite = 20)
    {
        return $query->orderByDesc('frecuencia_uso')->limit($limite);
    }
}
