<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HistoriaArchivo extends Model
{
    use HasFactory;

    protected $table = 'historia_archivos';

    protected $fillable = [
        'historia_clinica_id',
        'tipo',
        'nombre_original',
        'ruta_archivo',
        'mime_type',
        'tamano_bytes',
        'descripcion',
        'subido_por'
    ];

    public function historiaClinica()
    {
        return $this->belongsTo(HistoriaClinica::class);
    }

    public function subidoPor()
    {
        return $this->belongsTo(Usuario::class, 'subido_por');
    }

    // Accesor para URL completa del archivo
    public function getUrlAttribute()
    {
        return asset('storage/' . $this->ruta_archivo);
    }
}
