<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HistoriaEvolucion extends Model
{
    use HasFactory;

    protected $table = 'historia_evoluciones';

    protected $fillable = [
        'historia_clinica_id',
        'medico_id',
        'fecha_evolucion',
        'notas_soap',
        'estado_paciente',
        'cie10_id',
        'cie10_codigo_texto',
        'observaciones'
    ];

    protected $casts = [
        'fecha_evolucion' => 'datetime',
        'notas_soap' => 'array' // Cast automático a array/json
    ];

    public function historiaClinica()
    {
        return $this->belongsTo(HistoriaClinica::class);
    }

    public function medico()
    {
        return $this->belongsTo(Usuario::class, 'medico_id');
    }

    public function cie10()
    {
        return $this->belongsTo(Cie10Catalog::class, 'cie10_id');
    }
}
