<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MedicamentoReceta extends Model
{
    use HasFactory;

    protected $table = 'medicamentos_receta';

    protected $fillable = [
        'receta_id',
        'medicamento_catalogo_id',
        'nombre_medicamento',
        'dosis',
        'via_administracion',
        'frecuencia',
        'duracion_dias',
        'cantidad_total',
        'instrucciones_especiales'
    ];
    
    public $timestamps = false;
    const CREATED_AT = 'fecha_creacion';

    public function receta()
    {
        return $this->belongsTo(RecetaMedica::class, 'receta_id');
    }

    public function catalogo()
    {
        return $this->belongsTo(MedicamentoCatalogo::class, 'medicamento_catalogo_id');
    }
}
