<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecetaMedica extends Model
{
    use HasFactory;

    protected $table = 'recetas_medicas';

    protected $fillable = [
        'historia_clinica_id',
        'paciente_id',
        'medico_id',
        'fecha_emision',
        'vigencia_dias',
        'instrucciones_generales',
        'estado'
    ];

    protected $casts = [
        'fecha_emision' => 'date',
    ];

    public function paciente()
    {
        return $this->belongsTo(Paciente::class, 'paciente_id');
    }

    public function medico()
    {
        return $this->belongsTo(Usuario::class, 'medico_id');
    }

    public function medicamentos()
    {
        return $this->hasMany(MedicamentoReceta::class, 'receta_id');
    }

    public function historiaClinica()
    {
        return $this->belongsTo(HistoriaClinica::class, 'historia_clinica_id');
    }

    public function scopeActivas($query)
    {
        return $query->where('estado', 'activa');
    }

    public function scopeVencidas($query)
    {
        return $query->where('estado', 'vencida')
            ->orWhereDate('fecha_emision', '<', now()->subDays($this->vigencia_dias));
    }
}
