<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resultado extends Model
{
    protected $table = 'resultados';

    protected $fillable = [
        'paciente_id',
        'examen_id',
        'archivo_nombre',
        'archivo_ruta',
        'archivo_tipo',
        'archivo_tamano',
        'observaciones',
        'subido_por',
        'subido_en',
        'estado',
    ];

    protected $casts = [
        'archivo_tamano' => 'integer',
        'subido_en' => 'datetime',
    ];

    public function paciente()
    {
        return $this->belongsTo(Paciente::class);
    }

    public function examen()
    {
        return $this->belongsTo(Estudio::class, 'examen_id');
    }

    public function subidoPor()
    {
        return $this->belongsTo(Usuario::class, 'subido_por');
    }

    public function scopeActivos($query)
    {
        return $query->where('estado', 'activo');
    }
}
