# ✅ Checklist de Instalación - Cibertronia Salud

## 📋 Lista de Verificación

### Paso 1: Preparación
- [ ] Laragon está instalado en tu computadora
- [ ] Laragon está **CORRIENDO** (icono verde en la bandeja del sistema)
- [ ] MySQL está activo en Laragon

### Paso 2: Instalación de la Base de Datos

**Elige UNA de estas opciones:**

#### ☑️ Opción A: HeidiSQL (Recomendado para principiantes)
- [ ] Click derecho en Laragon → MySQL → Open
- [ ] En HeidiSQL: File → Load SQL file
- [ ] Navegar a: `C:\laragon\www\cibertronia-salud\database\cibertronia_salud.sql`
- [ ] Click en el botón azul ▶ Run (o presionar F9)
- [ ] Verificar que no haya errores en la salida

#### ☑️ Opción B: phpMyAdmin (Recomendado para usuarios web)
- [ ] Click derecho en Laragon → Database → phpMyAdmin
- [ ] Click en la pestaña "SQL"
- [ ] Click en "Choose File"
- [ ] Seleccionar: `C:\laragon\www\cibertronia-salud\database\cibertronia_salud.sql`
- [ ] Click en "Go"
- [ ] Verificar el mensaje de éxito

#### ☑️ Opción C: Línea de Comandos (Para usuarios avanzados)
- [ ] Abrir PowerShell
- [ ] Navegar a: `cd C:\laragon\www\cibertronia-salud`
- [ ] Ejecutar: `C:\laragon\bin\mysql\mysql-9.4.0-winx64\bin\mysql.exe -u root < database\cibertronia_salud.sql`
- [ ] Verificar que no haya errores

### Paso 3: Verificación
- [ ] Abrir HeidiSQL o phpMyAdmin
- [ ] Buscar la base de datos `cibertronia_salud` en la lista
- [ ] Verificar que existan 17 tablas
- [ ] Ejecutar: `SELECT * FROM usuarios;` (debe mostrar 5 usuarios)
- [ ] Ejecutar: `SELECT * FROM pacientes;` (debe mostrar 3 pacientes)

### Paso 4: Configuración de Laravel (Si usas Laravel)
- [ ] Copiar `.env.example` a `.env`: `cp .env.example .env`
- [ ] Editar `.env` y verificar:
  ```
  DB_DATABASE=cibertronia_salud
  DB_USERNAME=root
  DB_PASSWORD=
  ```
- [ ] Generar key de Laravel: `php artisan key:generate`
- [ ] Verificar conexión: `php artisan migrate:status`

### Paso 5: Prueba de Acceso
- [ ] Intentar login con:
  - Email: `admin@cibertroniasalud.com`
  - Password: `Admin123!`
- [ ] ✅ ¡Si funciona, la base de datos está lista!

---

## 🎯 Resultados Esperados

Después de completar todos los pasos, deberías tener:

✅ Base de datos `cibertronia_salud` creada
✅ 17 tablas instaladas y funcionando
✅ 5 usuarios de prueba disponibles
✅ 3 pacientes de ejemplo
✅ 3 vistas SQL funcionando
✅ 3 procedimientos almacenados listos
✅ Laravel configurado (si aplica)

---

## 🆘 Solución de Problemas

### ❌ No puedo conectar a MySQL
**Problema**: Error "Can't connect to MySQL server"
**Solución**:
1. Abre Laragon
2. Click en "Start All"
3. Espera a que el icono se ponga verde
4. Intenta de nuevo

### ❌ La base de datos ya existe
**Problema**: Error "Database already exists"
**Solución**:
1. Abre HeidiSQL
2. Click derecho en `cibertronia_salud` → Drop
3. Vuelve a ejecutar el script

### ❌ Access denied for user 'root'
**Problema**: No puedo acceder como root
**Solución**:
1. En Laragon, verifica la configuración de MySQL
2. Normalmente no tiene password
3. Si tiene, agrega `-p` al comando y escribe la password

### ❌ No encuentro la versión de MySQL
**Problema**: La ruta de MySQL no existe
**Solución**:
1. Ejecuta: `dir C:\laragon\bin\mysql\`
2. Usa la versión que veas listada
3. Ajusta el comando según tu versión

---

## 📝 Comandos Útiles de Verificación

```sql
-- Ver todas las bases de datos
SHOW DATABASES;

-- Usar la base de datos
USE cibertronia_salud;

-- Ver todas las tablas
SHOW TABLES;

-- Ver estructura de una tabla
DESCRIBE pacientes;

-- Contar registros
SELECT COUNT(*) FROM usuarios;  -- Debe ser 5
SELECT COUNT(*) FROM pacientes; -- Debe ser 3

-- Ver todos los usuarios
SELECT id, nombre, apellido, email, rol FROM usuarios;
```

---

## 🎉 ¡Felicidades!

Si completaste todos los checkboxes, tu base de datos está **100% lista** para comenzar a desarrollar tu sistema de salud.

---

## 📞 Próximo Paso

Una vez verificado todo, puedes comenzar a:
1. Crear los modelos de Laravel
2. Crear los controladores API
3. Desarrollar el frontend en React
4. Implementar autenticación

**¿Necesitas ayuda con alguno de estos pasos?** ¡Solo pregunta!
