# 📊 Diagrama Entidad-Relación: Cibertronia Salud

## 🔄 Relaciones entre Tablas

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                           SISTEMA CIBERTRONIA SALUD                              │
│                        Base de Datos Relacional - MariaDB                        │
└─────────────────────────────────────────────────────────────────────────────────┘


┌──────────────────┐
│    USUARIOS      │◄─────────────┐
├──────────────────┤              │
│ • id (PK)        │              │
│ • nombre         │              │
│ • apellido       │              │
│ • email          │              │  ┌─────────────────────┐
│ • password       │              │  │     PACIENTES       │
│ • rol            │              │  ├─────────────────────┤
│ • especialidad   │              │  │ • id (PK)           │
│ • estado         │              │  │ • numero_historia   │
└──────────────────┘              │  │ • nombre            │
         │                        │  │ • apellido          │
         │ registrado_por         │  │ • fecha_nacimiento  │
         └────────────────────────┼─▶│ • sexo              │
         │                        │  │ • numero_documento  │
         │ medico_id              │  │ • telefono          │
         │                        │  │ • grupo_sanguineo   │
         │                        │  │ • estado            │
         │                        │  └─────────────────────┘
         │                        │            │
         │                        │            │
         │                        │            │ paciente_id
         │                        │            ▼
    ┌────┴─────┐                 │  ┌─────────────────────┐
    │  CITAS   │                 │  │ ANTECEDENTES        │
    ├──────────┤                 │  │ MEDICOS             │
    │ • id     │                 │  ├─────────────────────┤
    │ • fecha  │                 │  │ • id (PK)           │
    │ • tipo   │                 │  │ • paciente_id (FK)  │
    │ • estado │                 │  │ • tipo              │
    │ • motivo │                 │  │ • descripcion       │
    └──────────┘                 │  │ • fecha_diagnostico │
         │                       │  └─────────────────────┘
         │ cita_id               │
         │                       │  ┌─────────────────────┐
         ▼                       │  │ SEGUROS_MEDICOS     │
┌─────────────────────┐          │  ├─────────────────────┤
│ HISTORIAS_CLINICAS  │          │  │ • id (PK)           │
├─────────────────────┤          │  │ • paciente_id (FK)  │
│ • id (PK)           │          │  │ • compania_seguro   │
│ • cita_id (FK)      │          │  │ • numero_poliza     │
│ • paciente_id (FK)  │◄─────────┘  │ • tipo_plan         │
│ • medico_id (FK)    │              │ • vigencia          │
│ • fecha_consulta    │              └─────────────────────┘
│ • presion_arterial  │
│ • temperatura       │              ┌─────────────────────┐
│ • peso/altura       │              │     VACUNAS         │
│ • diagnostico       │              ├─────────────────────┤
│ • tratamiento       │              │ • id (PK)           │
└─────────────────────┘              │ • paciente_id (FK)  │
         │                           │ • nombre_vacuna     │
         │ historia_clinica_id       │ • dosis_numero      │
         │                           │ • fecha_aplicacion  │
         ▼                           │ • lote              │
┌─────────────────────┐              └─────────────────────┘
│  RECETAS_MEDICAS    │
├─────────────────────┤
│ • id (PK)           │
│ • historia_id (FK)  │
│ • paciente_id (FK)  │
│ • medico_id (FK)    │
│ • fecha_emision     │
│ • vigencia_dias     │
│ • estado            │
└─────────────────────┘
         │
         │ receta_id
         │
         ▼
┌─────────────────────┐
│ MEDICAMENTOS_RECETA │
├─────────────────────┤
│ • id (PK)           │
│ • receta_id (FK)    │
│ • nombre_medicam... │
│ • dosis             │
│ • via_administr...  │
│ • frecuencia        │
│ • duracion_dias     │
└─────────────────────┘


┌─────────────────────┐
│  EXAMENES_MEDICOS   │
├─────────────────────┤
│ • id (PK)           │
│ • paciente_id (FK)  │
│ • medico_id (FK)    │
│ • historia_id (FK)  │
│ • tipo_examen       │
│ • fecha_solicitud   │
│ • resultados        │
│ • estado            │
└─────────────────────┘


┌─────────────────────┐              ┌─────────────────────┐
│    FACTURACION      │              │     AUDITORIA       │
├─────────────────────┤              ├─────────────────────┤
│ • id (PK)           │              │ • id (PK)           │
│ • numero_factura    │              │ • usuario_id (FK)   │
│ • paciente_id (FK)  │              │ • accion            │
│ • cita_id (FK)      │              │ • tabla_afectada    │
│ • fecha_emision     │              │ • registro_id       │
│ • total             │              │ • datos_anteriores  │
│ • estado            │              │ • datos_nuevos      │
│ • metodo_pago       │              │ • ip_address        │
└─────────────────────┘              │ • fecha_accion      │
                                     └─────────────────────┘
```

---

## 🔑 Leyenda

- **PK**: Primary Key (Llave Primaria)
- **FK**: Foreign Key (Llave Foránea)
- **─▶**: Relación uno a muchos
- **◄─**: Relación inversa

---

## 📋 Relaciones Principales

### 1️⃣ **Usuarios → Pacientes**
- Un usuario (recepcionista/admin) puede registrar múltiples pacientes
- Relación: `usuarios.id` ← `pacientes.registrado_por`

### 2️⃣ **Pacientes ↔ Citas**
- Un paciente puede tener múltiples citas
- Una cita pertenece a un paciente
- Relación: `pacientes.id` ← `citas.paciente_id`

### 3️⃣ **Usuarios (Médicos) ↔ Citas**
- Un médico puede tener múltiples citas asignadas
- Una cita es atendida por un médico
- Relación: `usuarios.id` ← `citas.medico_id` (donde rol = 'medico')

### 4️⃣ **Citas → Historias Clínicas**
- Una cita puede generar una historia clínica
- Relación **1:1**: `citas.id` ← `historias_clinicas.cita_id` (UNIQUE)

### 5️⃣ **Historias Clínicas → Recetas Médicas**
- Una historia clínica puede generar múltiples recetas
- Relación: `historias_clinicas.id` ← `recetas_medicas.historia_clinica_id`

### 6️⃣ **Recetas → Medicamentos**
- Una receta puede contener múltiples medicamentos
- Relación: `recetas_medicas.id` ← `medicamentos_receta.receta_id`

### 7️⃣ **Pacientes → Antecedentes Médicos**
- Un paciente puede tener múltiples antecedentes
- Relación: `pacientes.id` ← `antecedentes_medicos.paciente_id`

### 8️⃣ **Pacientes → Vacunas**
- Un paciente puede tener múltiples vacunas registradas
- Relación: `pacientes.id` ← `vacunas.paciente_id`

### 9️⃣ **Pacientes → Seguros Médicos**
- Un paciente puede tener múltiples seguros
- Relación: `pacientes.id` ← `seguros_medicos.paciente_id`

### 🔟 **Pacientes → Exámenes Médicos**
- Un paciente puede tener múltiples exámenes
- Relación: `pacientes.id` ← `examenes_medicos.paciente_id`

### 1️⃣1️⃣ **Citas → Facturación**
- Una cita puede generar una factura
- Relación: `citas.id` ← `facturacion.cita_id`

### 1️⃣2️⃣ **Usuarios → Auditoría**
- Todas las acciones de usuarios se registran
- Relación: `usuarios.id` ← `auditoria.usuario_id`

---

## 🎯 Cardinalidad

| Relación | Cardinalidad | Tipo |
|----------|--------------|------|
| Usuario → Paciente | 1:N | Un usuario registra muchos pacientes |
| Paciente → Cita | 1:N | Un paciente tiene muchas citas |
| Médico → Cita | 1:N | Un médico atiende muchas citas |
| Cita → Historia Clínica | 1:1 | Una cita genera una historia clínica |
| Historia → Receta | 1:N | Una historia puede generar varias recetas |
| Receta → Medicamentos | 1:N | Una receta contiene varios medicamentos |
| Paciente → Antecedentes | 1:N | Un paciente tiene varios antecedentes |
| Paciente → Vacunas | 1:N | Un paciente tiene varias vacunas |
| Paciente → Seguros | 1:N | Un paciente puede tener varios seguros |
| Paciente → Exámenes | 1:N | Un paciente tiene varios exámenes |
| Cita → Factura | 1:1 | Una cita genera una factura |

---

## 🔒 Restricciones de Integridad

### **ON DELETE CASCADE**
Cuando se elimina el registro padre, se eliminan automáticamente los registros hijos:
- Pacientes → Citas
- Pacientes → Historias Clínicas
- Pacientes → Antecedentes
- Pacientes → Vacunas
- Pacientes → Seguros
- Citas → Historias Clínicas
- Recetas → Medicamentos

### **ON DELETE RESTRICT**
Previene la eliminación si existen registros relacionados:
- Médicos (no se pueden eliminar si tienen citas)
- Pacientes → Facturación (no se puede eliminar paciente con facturas)

### **ON DELETE SET NULL**
Al eliminar el padre, el campo en el hijo se establece en NULL:
- Usuarios → Pacientes (registrado_por)
- Usuarios → Auditoría
- Citas → Historias Clínicas (si se permite)

---

## 📈 Campos Calculados Automáticos

La base de datos incluye campos que se calculan automáticamente:

1. **`pacientes.edad`**: Calculada desde fecha_nacimiento
2. **`historias_clinicas.imc`**: Calculado desde peso y altura
3. **`recetas_medicas.fecha_vencimiento`**: Calculada desde fecha_emision + vigencia_dias

---

## 🎨 Tipos de Datos Especiales

### **ENUM (Enumeraciones)**
Usados para campos con valores predefinidos:
- `usuarios.rol`: admin, medico, enfermero, recepcionista
- `pacientes.sexo`: M, F, Otro
- `citas.estado`: programada, confirmada, en_curso, completada, cancelada
- `facturacion.metodo_pago`: efectivo, tarjeta, transferencia, cheque

### **JSON**
Usado para almacenar datos estructurados:
- `historias_clinicas.archivos_adjuntos`: Array de archivos
- `auditoria.datos_anteriores / datos_nuevos`: Estado anterior y nuevo

### **VIRTUAL (Campos Calculados)**
Campos que se calculan en tiempo real sin ocupar espacio:
- `edad`, `imc`, `fecha_vencimiento`

---

Este diagrama muestra la estructura completa del sistema, diseñado para máxima flexibilidad y escalabilidad. 🚀
