# ⚡ Guía Rápida de Instalación

## 🚀 Opción 1: Desde HeidiSQL (Recomendado)

1. **Abrir Laragon** y asegurarte de que esté corriendo

2. **Click derecho en Laragon** → **MySQL** → **Open**
   - Se abrirá HeidiSQL automáticamente

3. En HeidiSQL:
   - Click en **File** → **Load SQL file...**
   - Navegar a: `C:\laragon\www\cibertronia-salud\database\cibertronia_salud.sql`
   - Click en **Open**
   - Click en el botón azul **▶ Run** (F9)

4. ¡Listo! La base de datos estará creada

---

## 🌐 Opción 2: Desde phpMyAdmin

1. **Abrir Laragon** → Click derecho → **Database** → **phpMyAdmin**

2. En phpMyAdmin:
   - Click en la pestaña **SQL**
   - Click en el botón **Choose File**
   - Seleccionar: `C:\laragon\www\cibertronia-salud\database\cibertronia_salud.sql`
   - Click en **Go**

3. ¡Listo!

---

## 💻 Opción 3: Línea de Comandos

1. **Abrir PowerShell** en el directorio del proyecto:
```powershell
cd C:\laragon\www\cibertronia-salud
```

2. **Ejecutar el comando** (ajusta la ruta de MySQL según tu versión):
```powershell
# Para MySQL 9.4
C:\laragon\bin\mysql\mysql-9.4.0-winx64\bin\mysql.exe -u root < database\cibertronia_salud.sql

# Para MySQL 8.0
C:\laragon\bin\mysql\mysql-8.0.30-winx64\bin\mysql.exe -u root < database\cibertronia_salud.sql
```

---

## ✅ Verificar la Instalación

### Desde HeidiSQL:
1. Actualizar la lista de bases de datos (F5)
2. Buscar `cibertronia_salud` en la lista
3. Expandir y verificar que existan las tablas

### Desde SQL:
```sql
USE cibertronia_salud;
SHOW TABLES;
```

Deberías ver 17 tablas:
- antecedentes_medicos
- auditoria
- citas
- examenes_medicos
- facturacion
- historias_clinicas
- medicamentos_receta
- pacientes
- recetas_medicas
- seguros_medicos
- usuarios
- vacunas
- (y más...)

---

## 🧪 Probar con Datos de Ejemplo

```sql
-- Ver usuarios creados
SELECT * FROM usuarios;

-- Ver pacientes de ejemplo
SELECT * FROM pacientes;

-- Ver todas las tablas
SHOW TABLES;

-- Ver estructura de una tabla
DESCRIBE pacientes;
```

---

## 🔧 Solución de Problemas

### ❌ Error: "Access denied for user"
**Solución**: Agregar contraseña si es necesario:
```powershell
C:\laragon\bin\mysql\mysql-9.4.0-winx64\bin\mysql.exe -u root -p < database\cibertronia_salud.sql
```

### ❌ Error: "Database already exists"
**Solución**: El script ya incluye `DROP DATABASE IF EXISTS`, pero si persiste:
```sql
DROP DATABASE IF EXISTS cibertronia_salud;
```
Luego volver a ejecutar el script.

### ❌ No encuentro mi versión de MySQL
**Solución**: Listar versiones disponibles:
```powershell
dir C:\laragon\bin\mysql\
```
Usar la ruta de la versión que veas listada.

---

## 📞 Siguiente Paso

Una vez instalada la base de datos:

```powershell
# Copiar archivo de configuración
cp .env.example .env

# Generar key de Laravel (si usas Laravel)
php artisan key:generate

# Verificar conexión
php artisan migrate:status
```

---

¡Todo listo para comenzar a desarrollar! 🎉
