# 🏥 Cibertronia Salud - Base de Datos

> ⚠️ **IMPORTANTE**: Antes de instalar la base de datos, asegúrate de que **Laragon esté corriendo**. Si no está iniciado, ningún comando funcionará.

## 📋 Resumen

Se ha creado una base de datos completa para el sistema **Cibertronia Salud**, un sistema profesional de registro y gestión de pacientes.

---

## 🗄️ Estructura de la Base de Datos

La base de datos `cibertronia_salud` incluye **17 tablas principales**:

### **Usuarios y Administración**
1. **`usuarios`** - Gestión de usuarios del sistema (médicos, enfermeros, administradores, recepcionistas)
2. **`auditoria`** - Registro de auditoría del sistema

### **Pacientes**
3. **`pacientes`** - Información general de pacientes
4. **`antecedentes_medicos`** - Antecedentes médicos del paciente
5. **`seguros_medicos`** - Información de seguros médicos

### **Citas y Consultas**
6. **`citas`** - Gestión de citas médicas
7. **`historias_clinicas`** - Registro de historias clínicas por consulta

### **Medicamentos y Tratamientos**
8. **`recetas_medicas`** - Gestión de recetas médicas
9. **`medicamentos_receta`** - Detalle de medicamentos en cada receta

### **Exámenes y Estudios**
10. **`examenes_medicos`** - Registro de exámenes y estudios médicos

### **Vacunación**
11. **`vacunas`** - Registro de vacunación de pacientes

### **Facturación**
12. **`facturacion`** - Gestión de facturación y pagos

---

## 🚀 Instalación

### **Opción 1: Usando el Script Automatizado**

1. Asegúrate de que **Laragon esté corriendo**
2. Ejecuta el archivo: `database/crear_base_datos.bat`
3. ¡Listo!

### **Opción 2: Manual desde Laragon**

1. Abre **Laragon**
2. Click en **Database** → **Open**
3. En HeidiSQL o phpMyAdmin, ejecuta el archivo: `database/cibertronia_salud.sql`

### **Opción 3: Línea de Comandos**

```bash
# Desde el directorio del proyecto
cd c:\laragon\www\cibertronia-salud

# Ejecutar el script SQL
C:\laragon\bin\mysql\[tu_version_mysql]\bin\mysql.exe -u root -p < database\cibertronia_salud.sql
```

---

## 👤 Usuarios de Ejemplo

Después de la instalación, estarán disponibles estos usuarios de prueba:

| Email | Contraseña | Rol |
|-------|-----------|-----|
| admin@cibertroniasalud.com | Admin123! | Administrador |
| dr.perez@cibertroniasalud.com | Admin123! | Médico (Medicina General) |
| dra.gonzalez@cibertroniasalud.com | Admin123! | Médico (Pediatría) |
| enfermera@cibertroniasalud.com | Admin123! | Enfermero |
| recepcion@cibertroniasalud.com | Admin123! | Recepcionista |

> ⚠️ **IMPORTANTE**: Cambia estas contraseñas antes de usar en producción.

---

## 📊 Vistas Útiles

La base de datos incluye vistas predefinidas:

1. **`vista_pacientes_ultima_cita`** - Pacientes con su última cita registrada
2. **`vista_citas_hoy`** - Todas las citas programadas para hoy
3. **`vista_historias_clinicas_resumen`** - Resumen de historias clínicas

### Ejemplo de uso:
```sql
-- Ver todas las citas de hoy
SELECT * FROM vista_citas_hoy;

-- Ver pacientes con su última cita
SELECT * FROM vista_pacientes_ultima_cita WHERE estado = 'activo';
```

---

## 🔧 Procedimientos Almacenados

### 1. **Obtener Historial Completo del Paciente**
```sql
CALL obtener_historial_paciente(1);
```
Retorna toda la información médica de un paciente: antecedentes, vacunas, historias clínicas y exámenes.

### 2. **Generar Número de Historia Automático**
```sql
CALL generar_numero_historia();
```
Genera automáticamente el siguiente número de historia clínica (formato: HC-2024-001).

### 3. **Agendar Cita con Validación**
```sql
CALL agendar_cita(
    1,                              -- ID del paciente
    2,                              -- ID del médico
    '2024-02-15 10:00:00',         -- Fecha y hora
    30,                             -- Duración en minutos
    'consulta general',             -- Tipo de cita
    'Control de rutina',            -- Motivo
    'Consultorio 1',                -- Sala
    1                               -- Creada por (usuario ID)
);
```
Valida conflictos de horario antes de agendar una cita.

---

## 📝 Características Principales

### ✅ **Signos Vitales**
Las historias clínicas registran:
- Presión arterial
- Frecuencia cardíaca
- Temperatura
- Frecuencia respiratoria
- Peso y altura (con cálculo automático de IMC)
- Saturación de oxígeno

### ✅ **Gestión de Recetas**
- Recetas médicas completas
- Detalle de medicamentos con dosis, frecuencia y duración
- Control de vigencia automático
- Múltiples vías de administración

### ✅ **Antecedentes Médicos**
Tipos de antecedentes:
- Personal
- Familiar
- Quirúrgico
- Hospitalario
- Traumático
- Gineco-obstétrico

### ✅ **Sistema de Auditoría**
Registro completo de todas las acciones realizadas en el sistema con:
- Usuario que realizó la acción
- Datos anteriores y nuevos (en formato JSON)
- IP y User Agent
- Fecha y hora exacta

### ✅ **Facturación Integrada**
- Generación automática de facturas
- Múltiples métodos de pago
- Control de estados (pendiente, pagada, parcial, vencida)
- Integración con seguros médicos

---

## 🔐 Seguridad

- **Contraseñas encriptadas** con bcrypt
- **Auditoría completa** de todas las acciones
- **Validaciones** a nivel de base de datos
- **Integridad referencial** con foreign keys
- **Campos calculados** automáticos (edad, IMC, fecha vencimiento)

---

## 📦 Pacientes de Ejemplo

Se incluyen 3 pacientes de prueba:

1. **Carlos Fernández Torres** (HC-2024-001)
2. **Ana Sánchez Ruiz** (HC-2024-002)
3. **Luis Ramírez Castro** (HC-2024-003)

---

## 🔌 Configuración para Laravel

Para conectar Laravel con esta base de datos, edita tu archivo `.env`:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=cibertronia_salud
DB_USERNAME=root
DB_PASSWORD=
```

---

## 📞 Próximos Pasos

1. ✅ Base de datos creada
2. ⏭️ Crear modelos de Laravel (Eloquent)
3. ⏭️ Crear controladores y rutas API
4. ⏭️ Crear componentes React para el frontend
5. ⏭️ Implementar autenticación y autorización
6. ⏭️ Crear dashboard y reportes

---

## 💡 Tips de Uso

### Consultar citas de un médico específico:
```sql
SELECT * FROM citas 
WHERE medico_id = 2 
AND DATE(fecha_cita) = CURDATE()
ORDER BY fecha_cita;
```

### Buscar pacientes por nombre:
```sql
SELECT * FROM pacientes 
WHERE CONCAT(nombre, ' ', apellido) LIKE '%Carlos%'
AND estado = 'activo';
```

### Ver historias clínicas recientes:
```sql
SELECT * FROM vista_historias_clinicas_resumen 
LIMIT 20;
```

---

## 📋 Respaldo

Para hacer un respaldo de la base de datos:

```bash
C:\laragon\bin\mysql\[version]\bin\mysqldump.exe -u root cibertronia_salud > backup_cibertronia_salud.sql
```

---

¿Necesitas alguna modificación o tabla adicional? ¡Estoy aquí para ayudarte! 🚀
