@echo off
chcp 65001 >nul
echo ==========================================
echo INSERTANDO CITAS DE PRUEBA
echo ==========================================
echo.

cd /d "C:\laragon\www\cibertronia-salud"

echo Verificando conexion con la base de datos...

REM Verificar si existe sqlite3
where sqlite3 >nul 2>nul
if %errorlevel% neq 0 (
    echo.
    echo ERROR: No se encontro sqlite3
    echo Intentando con PHP...
    goto :usar_php
)

echo.
echo Insertando citas usando SQLite...
sqlite3 database\database.sqlite < database\insertar_citas_prueba.sql

if %errorlevel% equ 0 (
    echo.
    echo ==========================================
    echo CITAS INSERTADAS CORRECTAMENTE
    echo ==========================================
    echo.
    echo Recarga la pagina de Citas para ver los cambios.
) else (
    echo.
    echo ERROR al insertar citas con SQLite
    goto :usar_php
)

goto :fin

:usar_php
echo.
echo Intentando insertar con PHP...
php -r "
require 'vendor/autoload.php';
\$pdo = new PDO('sqlite:database/database.sqlite');
\$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Obtener pacientes
\$pacientes = \$pdo->query('SELECT id FROM pacientes')->fetchAll(PDO::FETCH_COLUMN);
// Obtener un medico/admin
\$medico = \$pdo->query('SELECT id FROM usuarios WHERE rol IN (\"admin\", \"medico\") LIMIT 1')->fetchColumn();

if (empty(\$pacientes) || !\$medico) {
    echo \"No hay pacientes o medicos disponibles.\\n\";
    exit(1);
}

\$estados = ['programada', 'confirmada', 'en_curso', 'completada', 'cancelada', 'no_asistio'];
\$tipos = ['consulta_general', 'consulta_especializada', 'seguimiento', 'emergencia', 'control'];

\$count = 0;
foreach (\$pacientes as \$pacienteId) {
    for (\$i = 0; \$i < 2; \$i++) {
        \$dias = rand(0, 30);
        \$horas = rand(8, 17);
        \$fechaCita = date('Y-m-d H:i:s', strtotime('-' . \$dias . ' days +' . \$horas . ' hours'));
        \$estado = \$estados[array_rand(\$estados)];
        \$tipo = \$tipos[array_rand(\$tipos)];
        \$pagado = rand(0, 1);
        \$sala = 'Consultorio ' . rand(1, 5);
        
        \$sql = \"INSERT INTO citas (paciente_id, medico_id, fecha_cita, duracion_minutos, tipo_cita, motivo_consulta, estado, pagado, sala_consultorio, observaciones, creada_por, fecha_creacion, fecha_actualizacion) VALUES (?, ?, ?, 30, ?, 'Consulta medica de seguimiento', ?, ?, ?, 'Cita de prueba', ?, datetime('now'), datetime('now'))\";
        
        \$stmt = \$pdo->prepare(\$sql);
        \$stmt->execute([\$pacienteId, \$medico, \$fechaCita, \$tipo, \$estado, \$pagado, \$sala, \$medico]);
        \$count++;
    }
}

echo \"Citas creadas: \$count\\n\";
"

if %errorlevel% equ 0 (
    echo.
    echo ==========================================
    echo CITAS CREADAS CON PHP
    echo ==========================================
) else (
    echo.
    echo ERROR: No se pudieron crear las citas
    echo.
    echo Por favor, ejecuta manualmente:
    echo 1. Abre Laragon -^> Menu -^> MySQL -^> SQLite (o abre la terminal)
    echo 2. Ejecuta: sqlite3 database/database.sqlite
    echo 3. Luego ejecuta el SQL de: database/insertar_citas_prueba.sql
)

:fin
echo.
pause
