@echo off
chcp 65001 >nul
echo ======================================
echo 🔄 EJECUTANDO MIGRACIÓN
echo Sistema de Pagos + Portal del Paciente
echo ======================================
echo.

set DB_HOST=localhost
set DB_PORT=3306
set DB_NAME=cibertronia_salud
set DB_USER=root
set DB_PASS=

echo 📊 Configuración:
echo    Host: %DB_HOST%
echo    Puerto: %DB_PORT%
echo    Base de datos: %DB_NAME%
echo    Usuario: %DB_USER%
echo.

echo ⏳ Ejecutando migración...
echo.

mysql -h %DB_HOST% -P %DB_PORT% -u %DB_USER% %DB_NAME% < "%~dp0migrations\2024_02_17_000001_add_payment_system.sql"

if %ERRORLEVEL% EQU 0 (
    echo.
    echo ✅ MIGRACIÓN COMPLETADA EXITOSAMENTE!
    echo.
    echo Se han creado:
    echo    ✓ Tabla: pagos_examenes
    echo    ✓ Tabla: pacientes_usuario
    echo    ✓ Tabla: pacientes_sesiones
    echo    ✓ Vista: vista_examenes_con_pago
    echo    ✓ Procedimientos almacenados
    echo.
    echo 🔐 Credenciales de prueba para pacientes:
    echo    Email: [email del paciente en la BD]
    echo    Password: paciente123
    echo.
) else (
    echo.
    echo ❌ ERROR AL EJECUTAR LA MIGRACIÓN
    echo    Por favor verifica que:
    echo    - MySQL esté corriendo
    echo    - Las credenciales sean correctas
    echo    - La base de datos exista
    echo.
)

echo.
pause
