-- Insertar citas de prueba directamente en SQLite
-- Ejecutar: sqlite3 database/database.sqlite < database/insert_citas_simple.sql

-- Insertar 10 citas de prueba
INSERT INTO citas (paciente_id, medico_id, fecha_cita, duracion_minutos, tipo_cita, motivo_consulta, estado, pagado, sala_consultorio, observaciones, creada_por, fecha_creacion, fecha_actualizacion) VALUES 
(1, 1, '2025-02-19 09:00:00', 30, 'consulta_general', 'Consulta de control general', 'confirmada', 1, 'Consultorio 1', 'Cita de prueba', 1, '2025-02-18 10:00:00', '2025-02-19 08:00:00'),
(1, 1, '2025-02-18 14:30:00', 30, 'seguimiento', 'Seguimiento post-operatorio', 'completada', 1, 'Consultorio 2', 'Cita de prueba', 1, '2025-02-17 09:00:00', '2025-02-18 15:00:00'),
(2, 1, '2025-02-19 10:30:00', 30, 'consulta_especializada', 'Consulta con especialista', 'programada', 0, 'Consultorio 3', 'Cita de prueba', 1, '2025-02-18 11:00:00', '2025-02-18 11:00:00'),
(2, 1, '2025-02-17 16:00:00', 30, 'control', 'Control mensual', 'cancelada', 0, 'Consultorio 1', 'Cita de prueba', 1, '2025-02-16 08:00:00', '2025-02-17 10:00:00'),
(3, 1, '2025-02-19 11:00:00', 30, 'emergencia', 'Atención de emergencia', 'en_curso', 1, 'Consultorio 4', 'Cita de prueba', 1, '2025-02-19 10:50:00', '2025-02-19 10:50:00'),
(3, 1, '2025-02-16 09:30:00', 30, 'consulta_general', 'Consulta de rutina', 'no_asistio', 0, 'Consultorio 2', 'Cita de prueba', 1, '2025-02-15 14:00:00', '2025-02-16 10:00:00'),
(4, 1, '2025-02-19 15:00:00', 30, 'seguimiento', 'Seguimiento de tratamiento', 'confirmada', 1, 'Consultorio 1', 'Cita de prueba', 1, '2025-02-18 16:00:00', '2025-02-18 16:00:00'),
(4, 1, '2025-02-15 11:30:00', 30, 'control', 'Control de signos vitales', 'completada', 1, 'Consultorio 3', 'Cita de prueba', 1, '2025-02-14 09:00:00', '2025-02-15 12:00:00'),
(5, 1, '2025-02-19 16:30:00', 30, 'consulta_general', 'Primera consulta del paciente', 'programada', 0, 'Consultorio 2', 'Cita de prueba', 1, '2025-02-18 17:00:00', '2025-02-18 17:00:00'),
(5, 1, '2025-02-14 10:00:00', 30, 'consulta_especializada', 'Evaluación especializada', 'completada', 1, 'Consultorio 5', 'Cita de prueba', 1, '2025-02-13 11:00:00', '2025-02-14 11:00:00');

-- Verificar que se insertaron
SELECT 'Total de citas ahora: ' || COUNT(*) as mensaje FROM citas;
