-- Insertar citas de prueba para los pacientes existentes
-- Ejecutar esto en la base de datos SQLite

-- Primero verificamos si existe al menos un usuario (médico/admin)
-- y obtenemos los pacientes existentes

INSERT INTO citas (
    paciente_id, 
    medico_id, 
    fecha_cita, 
    duracion_minutos, 
    tipo_cita, 
    motivo_consulta, 
    estado, 
    pagado, 
    sala_consultorio, 
    observaciones, 
    creada_por,
    fecha_creacion,
    fecha_actualizacion
) 
SELECT 
    p.id as paciente_id,
    (SELECT id FROM usuarios WHERE rol IN ('admin', 'medico') LIMIT 1) as medico_id,
    datetime('now', '-' || (abs(random()) % 30) || ' days', '+' || (abs(random()) % 10) || ' hours') as fecha_cita,
    30 as duracion_minutos,
    CASE (abs(random()) % 5)
        WHEN 0 THEN 'consulta_general'
        WHEN 1 THEN 'consulta_especializada'
        WHEN 2 THEN 'seguimiento'
        WHEN 3 THEN 'emergencia'
        ELSE 'control'
    END as tipo_cita,
    'Consulta médica de seguimiento y revisión general' as motivo_consulta,
    CASE (abs(random()) % 6)
        WHEN 0 THEN 'programada'
        WHEN 1 THEN 'confirmada'
        WHEN 2 THEN 'en_curso'
        WHEN 3 THEN 'completada'
        WHEN 4 THEN 'cancelada'
        ELSE 'no_asistio'
    END as estado,
    CASE (abs(random()) % 2)
        WHEN 0 THEN 1
        ELSE 0
    END as pagado,
    'Consultorio ' || ((abs(random()) % 5) + 1) as sala_consultorio,
    'Cita creada para pruebas del sistema' as observaciones,
    (SELECT id FROM usuarios WHERE rol IN ('admin', 'medico') LIMIT 1) as creada_por,
    datetime('now', '-' || (abs(random()) % 5) || ' days') as fecha_creacion,
    datetime('now') as fecha_actualizacion
FROM pacientes p
WHERE EXISTS (SELECT 1 FROM usuarios WHERE rol IN ('admin', 'medico') LIMIT 1)
LIMIT 15;

-- Verificar cuántas citas se crearon
SELECT 'Total citas creadas: ' || COUNT(*) as mensaje FROM citas;
