<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pacientes', function (Blueprint $table) {
            $table->id();
            $table->string('ci', 20)->unique();
            $table->string('nombre', 100);
            $table->string('apellido', 100);
            $table->string('celular', 20);
            $table->enum('sexo', ['Femenino', 'Masculino']);
            $table->text('direccion')->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->string('email', 100)->nullable();
            $table->text('notas')->nullable();
            $table->foreignId('examen_id')->constrained('estudios');
            $table->decimal('precio', 10, 2);
            $table->enum('metodo_pago', ['Efectivo', 'QR', 'Débito', 'Crédito'])->default('Efectivo');
            $table->enum('estado_pago', ['pendiente', 'pagado'])->default('pendiente');
            $table->enum('estado', ['activo', 'inactivo'])->default('activo');
            $table->timestamps();
            
            $table->index('ci');
            $table->index('estado_pago');
            $table->index('estado');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pacientes');
    }
};
