<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resultados', function (Blueprint $table) {
            $table->id();
            $table->foreignId('paciente_id')->constrained('pacientes');
            $table->foreignId('examen_id')->constrained('estudios');
            $table->string('archivo_nombre', 255);
            $table->string('archivo_ruta', 255);
            $table->string('archivo_tipo', 50);
            $table->integer('archivo_tamano');
            $table->text('observaciones')->nullable();
            $table->foreignId('subido_por')->constrained('usuarios');
            $table->timestamp('subido_en')->useCurrent();
            $table->enum('estado', ['activo', 'inactivo'])->default('activo');
            $table->timestamps();
            
            $table->index('paciente_id');
            $table->index('examen_id');
            $table->index('estado');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resultados');
    }
};
