<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('citas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('paciente_id')->constrained('pacientes')->onDelete('cascade');
            $table->foreignId('medico_id')->constrained('usuarios')->onDelete('cascade');
            $table->dateTime('fecha_cita');
            $table->integer('duracion_minutos')->default(30);
            $table->enum('tipo_cita', ['consulta_general', 'consulta_especializada', 'seguimiento', 'emergencia', 'control', 'examen'])->default('consulta_general');
            $table->text('motivo_consulta');
            $table->enum('estado', ['programada', 'confirmada', 'en_curso', 'completada', 'cancelada', 'no_asistio'])->default('programada');
            $table->boolean('pagado')->default(false);
            $table->string('sala_consultorio')->nullable();
            $table->text('observaciones')->nullable();
            $table->foreignId('creada_por')->nullable()->constrained('usuarios')->nullOnDelete();
            
            $table->dateTime('fecha_creacion')->useCurrent();
            $table->dateTime('fecha_actualizacion')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('citas');
    }
};
