<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('citas', function (Blueprint $table) {
            // Agregar campo examen_id para relacionar con examenes_medicos
            $table->foreignId('examen_id')
                  ->nullable()
                  ->after('motivo_consulta')
                  ->constrained('examenes_medicos')
                  ->nullOnDelete();
            
            // Agregar índice para ordenamiento eficiente por fecha de creación
            $table->index('fecha_creacion', 'idx_citas_fecha_creacion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('citas', function (Blueprint $table) {
            $table->dropForeign(['examen_id']);
            $table->dropColumn('examen_id');
            $table->dropIndex('idx_citas_fecha_creacion');
        });
    }
};
