<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cie10_catalog', function (Blueprint $table) {
            $table->id();
            $table->string('codigo', 10)->unique()->comment('Código CIE-10 Ej: E11.9');
            $table->string('descripcion', 300)->comment('Descripción del diagnóstico');
            $table->string('categoria', 100)->nullable()->comment('Categoría principal');
            $table->string('subcategoria', 100)->nullable();
            $table->integer('frecuencia_uso')->default(0)->comment('Contador de usos para orden de sugerencias');
            $table->boolean('activo')->default(true);
            $table->timestamps();

            $table->index('codigo');
            $table->index('categoria');
            $table->index('frecuencia_uso');
            // Fulltext removed for compatibility
            $table->index('descripcion'); 
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cie10_catalog');
    }
};
