<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('historia_evoluciones', function (Blueprint $table) {
            $table->id();
            $table->integer('historia_clinica_id');
            $table->integer('medico_id');
            $table->timestamp('fecha_evolucion');

            // SOAP de la evolución
            $table->json('notas_soap')->nullable()
                ->comment('{"subjetivo":"...","objetivo":"...","analisis":"...","plan":"..."}');

            // Estado del paciente
            $table->enum('estado_paciente', ['estable', 'mejorando', 'empeorando', 'critico', 'dado_de_alta'])
                ->default('estable');

            // CIE-10 puede cambiar en evolución
            $table->unsignedBigInteger('cie10_id')->nullable();
            $table->string('cie10_codigo_texto', 20)->nullable();

            $table->text('observaciones')->nullable();
            $table->timestamps();

            $table->foreign('historia_clinica_id')
                ->references('id')->on('historias_clinicas')
                ->onDelete('cascade');
            $table->foreign('medico_id')
                ->references('id')->on('usuarios')
                ->onDelete('restrict');
            $table->foreign('cie10_id')
                ->references('id')->on('cie10_catalog')
                ->onDelete('set null');

            $table->index('historia_clinica_id');
            $table->index('medico_id');
            $table->index('fecha_evolucion');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('historia_evoluciones');
    }
};
