<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('historia_archivos', function (Blueprint $table) {
            $table->id();
            $table->integer('historia_clinica_id');

            $table->enum('tipo', [
                'rayos_x',
                'laboratorio',
                'ecografia',
                'tomografia',
                'resonancia',
                'electrocardiograma',
                'foto_herida',
                'receta_escaneada',
                'otro'
            ])->default('otro');

            $table->string('nombre_original', 255)->comment('Nombre original del archivo');
            $table->string('ruta_archivo', 500)->comment('Ruta relativa en storage');
            $table->string('mime_type', 100)->nullable();
            $table->unsignedBigInteger('tamano_bytes')->nullable();
            $table->text('descripcion')->nullable();
            $table->integer('subido_por')->nullable();
            $table->timestamps();

            $table->foreign('historia_clinica_id')
                ->references('id')->on('historias_clinicas')
                ->onDelete('cascade');
            $table->foreign('subido_por')
                ->references('id')->on('usuarios')
                ->onDelete('set null');

            $table->index('historia_clinica_id');
            $table->index('tipo');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('historia_archivos');
    }
};
