<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('medicamentos_catalogo', function (Blueprint $table) {
            $table->id();
            $table->string('nombre_generico', 255)->unique();
            $table->string('nombre_comercial', 255)->nullable();
            $table->string('concentracion', 200)->nullable()->comment('Ej: 5mg, 10mg, 25mg');
            $table->enum('via_administracion', ['oral', 'iv', 'im', 'sc', 'topical', 'nasal', 'ocular', 'auricular', 'inhalatoria', 'rectal', 'sublingual'])->default('oral');
            $table->string('categoria', 100)->index();
            $table->decimal('precio_bs', 10, 2)->default(0)->comment('Precio en Bolivianos');
            $table->string('presentacion', 100)->nullable()->comment('tableta, capsula, jarabe, ampolla, etc');
            $table->json('alternativas')->nullable()->comment('Array de nombres de medicamentos alternativos');
            $table->text('contraindicaciones')->nullable();
            $table->string('dosis_adulto', 255)->nullable()->comment('Dosis típica adulto');
            $table->string('dosis_pediatrica', 255)->nullable()->comment('Dosis típica pediátrica');
            $table->enum('estado', ['activo', 'descontinuado'])->default('activo');
            $table->timestamps();
            
            $table->index(['categoria', 'estado']);
            $table->index('nombre_generico');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('medicamentos_catalogo');
    }
};
