<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Cie10Catalog;

use Illuminate\Support\Facades\Schema;

class Cie10CatalogSeeder extends Seeder
{
    public function run()
    {
        // Deshabilitar FK temporalmente para limpiar
        Schema::disableForeignKeyConstraints();
        DB::table('cie10_catalog')->truncate();
        Schema::enableForeignKeyConstraints();

        $diagnosticos = [
            // --- ENFERMEDADES INFECCIOSAS ---
            ['codigo' => 'J00', 'descripcion' => 'Rinofaringitis agude [Resfriado común]', 'categoria' => 'Infecciosas'],
            ['codigo' => 'J03.9', 'descripcion' => 'Amigdalitis aguda, no especificada', 'categoria' => 'Infecciosas'],
            ['codigo' => 'J02.9', 'descripcion' => 'Faringitis aguda, no especificada', 'categoria' => 'Infecciosas'],
            ['codigo' => 'J06.9', 'descripcion' => 'Infección aguda de las vías respiratorias superiores, no especificada', 'categoria' => 'Infecciosas'],
            ['codigo' => 'J18.9', 'descripcion' => 'Neumonía, no especificada', 'categoria' => 'Infecciosas'],
            ['codigo' => 'A09', 'descripcion' => 'Diarrea y gastroenteritis de presunto origen infeccioso', 'categoria' => 'Infecciosas'],
            ['codigo' => 'N39.0', 'descripcion' => 'Infección de vías urinarias, sitio no especificado', 'categoria' => 'Infecciosas'],
            ['codigo' => 'B37.3', 'descripcion' => 'Candidiasis de la vulva y de la vagina', 'categoria' => 'Infecciosas'],
            ['codigo' => 'B01.9', 'descripcion' => 'Varicela sin complicaciones', 'categoria' => 'Infecciosas'],
            ['codigo' => 'A90', 'descripcion' => 'Fiebre del dengue [Dengue clásico]', 'categoria' => 'Infecciosas'],

            // --- ENDOCRINAS / METABÓLICAS ---
            ['codigo' => 'E11.9', 'descripcion' => 'Diabetes mellitus tipo 2 sin complicaciones', 'categoria' => 'Endocrinas'],
            ['codigo' => 'E10.9', 'descripcion' => 'Diabetes mellitus tipo 1 sin complicaciones', 'categoria' => 'Endocrinas'],
            ['codigo' => 'E66.9', 'descripcion' => 'Obesidad, no especificada', 'categoria' => 'Metabólicas'],
            ['codigo' => 'E66.0', 'descripcion' => 'Obesidad debida a exceso de calorías', 'categoria' => 'Metabólicas'],
            ['codigo' => 'E78.5', 'descripcion' => 'Hiperlipidemia, no especificada (Colesterol alto)', 'categoria' => 'Metabólicas'],
            ['codigo' => 'E03.9', 'descripcion' => 'Hipotiroidismo, no especificado', 'categoria' => 'Endocrinas'],
            ['codigo' => 'E50.9', 'descripcion' => 'Deficiencia de vitamina A, no especificada', 'categoria' => 'Nutricionales'],
            ['codigo' => 'E56.9', 'descripcion' => 'Deficiencia de vitaminas, no especificada', 'categoria' => 'Nutricionales'],
            ['codigo' => 'D50.9', 'descripcion' => 'Anemia por deficiencia de hierro, sin otra especificación', 'categoria' => 'Nutricionales'],

            // --- CARDIOVASCULARES ---
            ['codigo' => 'I10', 'descripcion' => 'Hipertensión esencial (primaria)', 'categoria' => 'Cardiovasculares'],
            ['codigo' => 'I11.9', 'descripcion' => 'Enfermedad cardíaca hipertensiva sin insuficiencia cardíaca', 'categoria' => 'Cardiovasculares'],
            ['codigo' => 'I20.9', 'descripcion' => 'Angina de pecho, no especificada', 'categoria' => 'Cardiovasculares'],
            ['codigo' => 'I21.9', 'descripcion' => 'Infarto agudo del miocardio, sin otra especificación', 'categoria' => 'Cardiovasculares'],
            ['codigo' => 'I50.9', 'descripcion' => 'Insuficiencia cardíaca, no especificada', 'categoria' => 'Cardiovasculares'],
            ['codigo' => 'I83.9', 'descripcion' => 'Venas varicosas de los miembros inferiores sin úlcera ni inflamación', 'categoria' => 'Cardiovasculares'],

            // --- GASTROINTESTINALES ---
            ['codigo' => 'K29.7', 'descripcion' => 'Gastritis, no especificada', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K21.9', 'descripcion' => 'Enfermedad por reflujo gastroesofágico sin esofagitis', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K30', 'descripcion' => 'Dispepsia (Indigestión)', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'R10.4', 'descripcion' => 'Dolor abdominal, no especificado', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K58.9', 'descripcion' => 'Síndrome del intestino irritable, sin diarrea', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K59.0', 'descripcion' => 'Constipación (Estreñimiento)', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K80.2', 'descripcion' => 'Cálculo de la vesícula biliar sin colecistitis', 'categoria' => 'Gastrointestinales'],
            ['codigo' => 'K81.9', 'descripcion' => 'Colecistitis, no especificada', 'categoria' => 'Gastrointestinales'],

            // --- MUSCULOESQUELÉTICAS ---
            ['codigo' => 'M54.5', 'descripcion' => 'Lumbago no especificado', 'categoria' => 'Musculoesqueléticas'],
            ['codigo' => 'M79.1', 'descripcion' => 'Mialgia (Dolor muscular)', 'categoria' => 'Musculoesqueléticas'],
            ['codigo' => 'M25.5', 'descripcion' => 'Dolor en articulación', 'categoria' => 'Musculoesqueléticas'],
            ['codigo' => 'M19.9', 'descripcion' => 'Artrosis, no especificada', 'categoria' => 'Musculoesqueléticas'],
            ['codigo' => 'M54.2', 'descripcion' => 'Cervicalgia (Dolor de cuello)', 'categoria' => 'Musculoesqueléticas'],
            ['codigo' => 'S01.9', 'descripcion' => 'Herida de la cabeza, parte no especificada', 'categoria' => 'Traumatismos'],
            ['codigo' => 'S83.6', 'descripcion' => 'Esguince y torcedura de otras partes y las no especificadas de la rodilla', 'categoria' => 'Traumatismos'],
            ['codigo' => 'S93.4', 'descripcion' => 'Esguince y torcedura del tobillo', 'categoria' => 'Traumatismos'],
            ['codigo' => 'T14.0', 'descripcion' => 'Traumatismo superficial de región no especificada del cuerpo', 'categoria' => 'Traumatismos'],

            // --- SISTEMA NERVIOSO / MENTAL ---
            ['codigo' => 'R51', 'descripcion' => 'Cefalea (Dolor de cabeza)', 'categoria' => 'Neurológicas'],
            ['codigo' => 'G43.9', 'descripcion' => 'Migraña, no especificada', 'categoria' => 'Neurológicas'],
            ['codigo' => 'G40.9', 'descripcion' => 'Epilepsia, tipo no especificado', 'categoria' => 'Neurológicas'],
            ['codigo' => 'F32.9', 'descripcion' => 'Episodio depresivo, no especificado', 'categoria' => 'Salud Mental'],
            ['codigo' => 'F41.1', 'descripcion' => 'Trastorno de ansiedad generalizada', 'categoria' => 'Salud Mental'],
            ['codigo' => 'F41.9', 'descripcion' => 'Trastorno de ansiedad, no especificado', 'categoria' => 'Salud Mental'],
            ['codigo' => 'G47.0', 'descripcion' => 'Trastornos del inicio y del mantenimiento del sueño [insomnios]', 'categoria' => 'Salud Mental'],
            ['codigo' => 'R42', 'descripcion' => 'Mareo y desvanecimiento', 'categoria' => 'Neurológicas'],

            // --- PIEL ---
            ['codigo' => 'L20.9', 'descripcion' => 'Dermatitis atópica, no especificada', 'categoria' => 'Dermatológicas'],
            ['codigo' => 'L70.0', 'descripcion' => 'Acné vulgar', 'categoria' => 'Dermatológicas'],
            ['codigo' => 'L50.9', 'descripcion' => 'Urticaria, no especificada', 'categoria' => 'Dermatológicas'],
            ['codigo' => 'B35.9', 'descripcion' => 'Dermatofitosis, no especificada (Hongo)', 'categoria' => 'Dermatológicas'],
            ['codigo' => 'L03.9', 'descripcion' => 'Celulitis, no especificada', 'categoria' => 'Dermatológicas'],

            // --- GINECOLOGÍA / OBSTETRICIA ---
            ['codigo' => 'N94.6', 'descripcion' => 'Dismenorrea, no especificada', 'categoria' => 'Ginecológicas'],
            ['codigo' => 'N91.2', 'descripcion' => 'Amenorrea, sin otra especificación', 'categoria' => 'Ginecológicas'],
            ['codigo' => 'Z30.0', 'descripcion' => 'Consejo y asesoramiento general sobre la anticoncepción', 'categoria' => 'Ginecológicas'],
            ['codigo' => 'Z32.1', 'descripcion' => 'Embarazo confirmado', 'categoria' => 'Obstetricia'],
            ['codigo' => 'O21.0', 'descripcion' => 'Hiperemesis gravídica leve (Vómitos embarazo)', 'categoria' => 'Obstetricia'],
            ['codigo' => 'O80.9', 'descripcion' => 'Parto único espontáneo, sin otra especificación', 'categoria' => 'Obstetricia'],

            // --- OTROS SÍNTOMAS GENERALES ---
            ['codigo' => 'R50.9', 'descripcion' => 'Fiebre, no especificada', 'categoria' => 'Generales'],
            ['codigo' => 'R05', 'descripcion' => 'Tos', 'categoria' => 'Generales'],
            ['codigo' => 'R06.0', 'descripcion' => 'Disnea (Dificultad respiratoria)', 'categoria' => 'Generales'],
            ['codigo' => 'R11', 'descripcion' => 'Náusea y vómito', 'categoria' => 'Generales'],
            ['codigo' => 'R53', 'descripcion' => 'Malestar y fatiga', 'categoria' => 'Generales'],
            ['codigo' => 'Z00.0', 'descripcion' => 'Examen médico general', 'categoria' => 'Control'],
        ];

        foreach ($diagnosticos as $diag) {
            Cie10Catalog::create([
                'codigo' => $diag['codigo'],
                'descripcion' => $diag['descripcion'],
                'categoria' => $diag['categoria'],
                'frecuencia_uso' => rand(1, 100), // Simular popularidad
                'activo' => true,
            ]);
        }
    }
}
