<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Cita;
use App\Models\Paciente;
use App\Models\Usuario;
use Carbon\Carbon;

class CitasExtraSeeder extends Seeder
{
    public function run()
    {
        // Obtener médico y pacientes
        $medico = Usuario::where('rol', 'medico')->first();
        if (!$medico) {
            $medico = Usuario::first(); // Fallback
        }
        
        $pacientes = Paciente::all();
        
        if ($pacientes->isEmpty()) {
            $this->command->warn("No hay pacientes para crear citas.");
            return;
        }

        $estados = ['programada', 'confirmada', 'cancelada', 'no_asistio', 'completada'];
        $tipos = ['consulta_general', 'consulta_especializada', 'control', 'emergencia'];
        
        $this->command->info("Creando 10 citas variadas...");

        for ($i = 0; $i < 10; $i++) {
            $paciente = $pacientes->random();
            $estado = $estados[array_rand($estados)];
            $tipo = $tipos[array_rand($tipos)];
            
            // Fechas aleatorias entre semana pasada y próxima semana
            $dias = rand(-7, 7);
            $hora = rand(8, 17);
            $fecha = Carbon::now()->addDays($dias)->setHour($hora)->setMinute(0)->setSecond(0);

            // Si es completada o cancelada, mejor que sea en el pasado
            if (in_array($estado, ['completada', 'cancelada', 'no_asistio'])) {
                $fecha = Carbon::now()->subDays(rand(1, 10))->setHour($hora);
            } else {
                // Programadas/Confirmadas a futuro
                $fecha = Carbon::now()->addDays(rand(1, 10))->setHour($hora);
            }

            try {
                Cita::create([
                    'paciente_id' => $paciente->id,
                    'medico_id' => $medico->id,
                    'fecha_cita' => $fecha,
                    'duracion_minutos' => 30,
                    'tipo_cita' => $tipo,
                    'motivo_consulta' => "Consulta de ejemplo #$i - $tipo",
                    'estado' => $estado,
                    'sala_consultorio' => 'Consultorio ' . rand(1, 5),
                    'observaciones' => "Cita generada automáticamente ($estado)",
                    'creada_por' => $medico->id
                ]);
            } catch (\Exception $e) {
                // Ignorar colisiones de horario en seeder
            }
        }
        
        $this->command->info("Citas creadas exitosamente.");
    }
}
