<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Cita;
use App\Models\Paciente;
use App\Models\Usuario;
use Carbon\Carbon;

class CitasTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener todos los pacientes
        $pacientes = Paciente::all();
        
        if ($pacientes->isEmpty()) {
            $this->command->info('No hay pacientes para crear citas.');
            return;
        }

        // Obtener un médico (usuario con rol médico o admin)
        $medico = Usuario::whereIn('rol', ['medico', 'admin'])->first();
        
        if (!$medico) {
            $this->command->info('No hay médicos disponibles.');
            return;
        }

        $estados = ['programada', 'confirmada', 'en_curso', 'completada', 'cancelada', 'no_asistio'];
        $tiposCita = ['consulta_general', 'consulta_especializada', 'seguimiento', 'emergencia', 'control'];
        
        // Crear 2-3 citas por paciente
        foreach ($pacientes as $index => $paciente) {
            $numCitas = rand(2, 3);
            
            for ($i = 0; $i < $numCitas; $i++) {
                $fechaCita = Carbon::now()->subDays(rand(0, 30))->addHours(rand(8, 17));
                
                Cita::create([
                    'paciente_id' => $paciente->id,
                    'medico_id' => $medico->id,
                    'fecha_cita' => $fechaCita,
                    'duracion_minutos' => 30,
                    'tipo_cita' => $tiposCita[array_rand($tiposCita)],
                    'motivo_consulta' => 'Consulta médica de seguimiento y revisión general del paciente',
                    'estado' => $estados[array_rand($estados)],
                    'pagado' => (bool)rand(0, 1),
                    'sala_consultorio' => 'Consultorio ' . rand(1, 5),
                    'observaciones' => 'Cita creada para pruebas del sistema',
                    'creada_por' => $medico->id,
                ]);
            }
            
            $this->command->info("Creadas {$numCitas} citas para: {$paciente->nombre} {$paciente->apellido}");
        }
        
        $totalCitas = Cita::count();
        $this->command->info("Total de citas creadas: {$totalCitas}");
    }
}
