<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class DatosIniciales extends Seeder
{
    public function run(): void
    {
        // =============================================
        // USUARIOS
        // =============================================
        
        // Agregar Administrador Pukriento
        $adminPukriento = [
            'nombre'     => 'Administrador',
            'apellido'   => 'Principal',
            'password'   => Hash::make('Mela2024'), // Puedes cambiar esto al texto completo que necesites
            'rol'        => 'admin',
            'estado'     => 'activo',
        ];
        
        if (DB::table('usuarios')->where('email', 'pukriento@gmail.com')->exists()) {
             DB::table('usuarios')->where('email', 'pukriento@gmail.com')->update($adminPukriento);
        } else {
             DB::table('usuarios')->insert(array_merge($adminPukriento, ['email' => 'pukriento@gmail.com']));
        }

        // Recuperar también al Admin Default original (por si acaso quieres los dos)
        $adminDefault = [
            'nombre'     => 'Admin',
            'apellido'   => 'Sistema',
            'password'   => Hash::make('admin123'),
            'rol'        => 'admin',
            'estado'     => 'activo',
        ];
        
        if (DB::table('usuarios')->where('email', 'admin@cibertronia.com')->exists()) {
             DB::table('usuarios')->where('email', 'admin@cibertronia.com')->update($adminDefault);
        } else {
             DB::table('usuarios')->insert(array_merge($adminDefault, ['email' => 'admin@cibertronia.com']));
        }


        // =============================================
        // CATEGORIAS
        // =============================================
        $categorias = [
            ['nombre' => 'Hematología',   'descripcion' => 'Análisis de sangre y componentes sanguíneos',           'orden' => 1],
            ['nombre' => 'Bioquímica',    'descripcion' => 'Análisis bioquímicos: glucosa, lípidos, enzimas, etc.',  'orden' => 2],
            ['nombre' => 'Microbiología', 'descripcion' => 'Cultivos, antibiogramas e identificación de microorganismos', 'orden' => 3],
            ['nombre' => 'Inmunología',   'descripcion' => 'Pruebas inmunológicas y serología',                      'orden' => 4],
            ['nombre' => 'Urianálisis',   'descripcion' => 'Análisis de orina y sedimento urinario',                 'orden' => 5],
            ['nombre' => 'Parasitología', 'descripcion' => 'Detección de parásitos intestinales y sanguíneos',       'orden' => 6],
            ['nombre' => 'Hormonología',  'descripcion' => 'Determinación de hormonas y marcadores tumorales',       'orden' => 7],
            ['nombre' => 'Coagulación',   'descripcion' => 'Pruebas de hemostasia y coagulación',                    'orden' => 8],
            ['nombre' => 'Imagenología',  'descripcion' => 'Rayos X, ecografías y tomografías',                      'orden' => 9],
            ['nombre' => 'Micronutrientes','descripcion' => 'Vitaminas, minerales y oligoelementos',                  'orden' => 10],
        ];

        foreach ($categorias as $cat) {
            if (!DB::table('categorias')->where('nombre', $cat['nombre'])->exists()) {
                DB::table('categorias')->insert(array_merge($cat, [
                    'estado'     => 'activo',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]));
            }
        }

        // =============================================
        // EXAMENES / ESTUDIOS
        // =============================================
        $examenes = [
            // Hematología
            ['codigo' => 'HEM001', 'nombre' => 'Hemograma Completo',           'descripcion' => 'Recuento de células sanguíneas completo con diferencial',  'precio' => 45.00,  'categoria' => 'Hematología'],
            ['codigo' => 'HEM002', 'nombre' => 'Grupo Sanguíneo y Factor RH',  'descripcion' => 'Determinación de grupo ABO y factor Rh',                    'precio' => 25.00,  'categoria' => 'Hematología'],
            ['codigo' => 'HEM003', 'nombre' => 'Velocidad de Sedimentación',   'descripcion' => 'VSG - Eritrosedimentación',                                  'precio' => 20.00,  'categoria' => 'Hematología'],
            // Bioquímica
            ['codigo' => 'BIO001', 'nombre' => 'Glucosa en Ayunas',            'descripcion' => 'Determinación de glucosa en sangre en ayunas',              'precio' => 20.00,  'categoria' => 'Bioquímica'],
            ['codigo' => 'BIO002', 'nombre' => 'Perfil Lipídico',              'descripcion' => 'Colesterol total, HDL, LDL, triglicéridos',                 'precio' => 60.00,  'categoria' => 'Bioquímica'],
            ['codigo' => 'BIO003', 'nombre' => 'Perfil Hepático',              'descripcion' => 'TGO, TGP, Fosfatasa Alcalina, Bilirrubinas',                'precio' => 70.00,  'categoria' => 'Bioquímica'],
            ['codigo' => 'BIO004', 'nombre' => 'Perfil Renal',                 'descripcion' => 'Creatinina, Urea, Ácido Úrico',                             'precio' => 55.00,  'categoria' => 'Bioquímica'],
            ['codigo' => 'BIO005', 'nombre' => 'Proteína C Reactiva (PCR)',    'descripcion' => 'Marcador de inflamación sistémica',                          'precio' => 35.00,  'categoria' => 'Bioquímica'],
            // Inmunología
            ['codigo' => 'INM001', 'nombre' => 'Prueba de VIH',                'descripcion' => 'Tamizaje de VIH 1 y 2',                                     'precio' => 50.00,  'categoria' => 'Inmunología'],
            ['codigo' => 'INM002', 'nombre' => 'VDRL / RPR (Sífilis)',         'descripcion' => 'Prueba serológica para sífilis',                             'precio' => 30.00,  'categoria' => 'Inmunología'],
            ['codigo' => 'INM003', 'nombre' => 'Hepatitis B (HBsAg)',          'descripcion' => 'Antígeno de superficie de hepatitis B',                      'precio' => 40.00,  'categoria' => 'Inmunología'],
            ['codigo' => 'INM004', 'nombre' => 'Hepatitis C (Anti-VHC)',       'descripcion' => 'Anticuerpos contra hepatitis C',                             'precio' => 45.00,  'categoria' => 'Inmunología'],
            // Urianálisis
            ['codigo' => 'URI001', 'nombre' => 'Urianálisis Completo',         'descripcion' => 'Examen físico, químico y microscópico de orina',             'precio' => 25.00,  'categoria' => 'Urianálisis'],
            ['codigo' => 'URI002', 'nombre' => 'Urocultivo',                   'descripcion' => 'Cultivo y antibiograma de orina',                            'precio' => 60.00,  'categoria' => 'Urianálisis'],
            // Parasitología
            ['codigo' => 'PAR001', 'nombre' => 'Coproparasitológico',          'descripcion' => 'Examen de heces para parásitos intestinales',                'precio' => 30.00,  'categoria' => 'Parasitología'],
            ['codigo' => 'PAR002', 'nombre' => 'Test de Graham',               'descripcion' => 'Detección de Enterobius vermicularis (oxiuros)',              'precio' => 25.00,  'categoria' => 'Parasitología'],
            // Hormonología
            ['codigo' => 'HOR001', 'nombre' => 'Hormona Tiroidea TSH',         'descripcion' => 'Hormona estimulante de tiroides',                            'precio' => 65.00,  'categoria' => 'Hormonología'],
            ['codigo' => 'HOR002', 'nombre' => 'T3 y T4 Libre',                'descripcion' => 'Hormonas tiroideas activas',                                  'precio' => 75.00,  'categoria' => 'Hormonología'],
            ['codigo' => 'HOR003', 'nombre' => 'Prueba de Embarazo (βhCG)',     'descripcion' => 'Gonadotropina coriónica humana en sangre',                   'precio' => 40.00,  'categoria' => 'Hormonología'],
            ['codigo' => 'HOR004', 'nombre' => 'Testosterona Total',            'descripcion' => 'Determinación de testosterona sérica',                        'precio' => 70.00,  'categoria' => 'Hormonología'],
            // Coagulación
            ['codigo' => 'COA001', 'nombre' => 'Tiempo de Protrombina (TP)',   'descripcion' => 'Evaluación de la vía extrínseca de coagulación',              'precio' => 35.00,  'categoria' => 'Coagulación'],
            ['codigo' => 'COA002', 'nombre' => 'Tiempo de Tromboplastina (TTP)','descripcion' => 'Evaluación de la vía intrínseca de coagulación',            'precio' => 35.00,  'categoria' => 'Coagulación'],
            // Imagenología
            ['codigo' => 'IMG001', 'nombre' => 'Radiografía de Tórax',         'descripcion' => 'Rx de tórax PA y lateral',                                   'precio' => 80.00,  'categoria' => 'Imagenología'],
            ['codigo' => 'IMG002', 'nombre' => 'Ecografía Abdominal',           'descripcion' => 'Ultrasonido de abdomen completo',                             'precio' => 120.00, 'categoria' => 'Imagenología'],
            ['codigo' => 'IMG003', 'nombre' => 'Ecografía Pélvica',             'descripcion' => 'Ultrasonido de pelvis y órganos pélvicos',                   'precio' => 110.00, 'categoria' => 'Imagenología'],
            // Micronutrientes
            ['codigo' => 'MIC001', 'nombre' => 'Vitamina D (25-OH)',            'descripcion' => 'Determinación de vitamina D sérica',                          'precio' => 90.00,  'categoria' => 'Micronutrientes'],
            ['codigo' => 'MIC002', 'nombre' => 'Vitamina B12',                  'descripcion' => 'Determinación de Cianocobalamina sérica',                     'precio' => 75.00,  'categoria' => 'Micronutrientes'],
            ['codigo' => 'MIC003', 'nombre' => 'Hierro Sérico y TIBC',          'descripcion' => 'Hierro, transferrina y capacidad de fijación',                'precio' => 60.00,  'categoria' => 'Micronutrientes'],
        ];

        foreach ($examenes as $ex) {
            if (!DB::table('estudios')->where('codigo', $ex['codigo'])->exists()) {
                DB::table('estudios')->insert([
                    'codigo'      => $ex['codigo'],
                    'nombre'      => $ex['nombre'],
                    'descripcion' => $ex['descripcion'],
                    'precio'      => $ex['precio'],
                    'categoria'   => $ex['categoria'],
                    'estado'      => 'activo',
                    'created_at'  => now(),
                    'updated_at'  => now(),
                ]);
            }
        }

        $this->command->info('✅ Datos iniciales insertados: categorías, exámenes y usuario admin.');
    }
}
