<?php

namespace Database\Seeders;

use App\Models\MedicamentoCatalogo;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class MedicamentoCatalogoSeeder extends Seeder
{
    public function run(): void
    {
        $jsonPath = storage_path('app/medicamentos.json');
        
        if (!File::exists($jsonPath)) {
            $this->command->error("Archivo JSON no encontrado: {$jsonPath}");
            return;
        }

        $medicamentos = json_decode(File::get($jsonPath), true);
        
        if (json_last_error() !== JSON_ERROR_NONE) {
            $this->command->error("Error al parsear JSON: " . json_last_error_msg());
            return;
        }

        $this->command->info("Cargando " . count($medicamentos) . " medicamentos...");

        foreach ($medicamentos as $med) {
            MedicamentoCatalogo::create([
                'nombre_generico' => $med['nombre_generico'],
                'nombre_comercial' => $med['nombre_comercial'],
                'concentracion' => $med['concentracion'],
                'via_administracion' => $med['via_administracion'],
                'categoria' => $med['categoria'],
                'precio_bs' => $med['precio_bs'],
                'presentacion' => $med['presentacion'],
                'alternativas' => json_encode($med['alternativas']),
                'contraindicaciones' => $med['contraindicaciones'],
                'dosis_adulto' => $med['dosis_adulto'],
                'dosis_pediatrica' => $med['dosis_pediatrica'],
                'estado' => 'activo',
            ]);
        }

        $this->command->info('Medicamentos cargados correctamente.');
    }
}
