<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

$cols = \Illuminate\Support\Facades\Schema::getColumnListing('pacientes');
echo "Columnas de 'pacientes': " . implode(', ', $cols) . PHP_EOL;

// Probar la query exacta del controlador
echo PHP_EOL . "Probando orderBy fecha_registro..." . PHP_EOL;
try {
    $result = \App\Models\Paciente::orderBy('fecha_registro', 'desc')->paginate(15);
    echo "OK - Total pacientes: " . $result->total() . PHP_EOL;
} catch (\Exception $e) {
    echo "ERROR: " . $e->getMessage() . PHP_EOL;
    
    // Si falla, intentar con created_at
    echo "Intentando con created_at..." . PHP_EOL;
    $result = \App\Models\Paciente::orderBy('created_at', 'desc')->paginate(15);
    echo "OK con created_at - Total: " . $result->total() . PHP_EOL;
}
