<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Http\Request;
use App\Http\Controllers\API\PacienteController;
use App\Models\Paciente;

echo "=== DIAGNÓSTICO DE SELECTOR DE PACIENTES ===" . PHP_EOL;

// 1. Verificar si hay pacientes
$count = Paciente::count();
echo "Total pacientes en DB: $count" . PHP_EOL;

if ($count === 0) {
    echo "¡ALERTA! No hay pacientes en la base de datos." . PHP_EOL;
    exit;
}

// 2. Simular la petición del select (per_page=100)
echo PHP_EOL . "Simulando petición GET /api/pacientes?per_page=100" . PHP_EOL;

try {
    $controller = new PacienteController();
    $request = Request::create('/api/pacientes', 'GET', ['per_page' => 100]);
    
    // Inyectar request
    $response = $controller->index($request);
    
    if ($response->status() !== 200) {
        echo "ERROR: Status code " . $response->status() . PHP_EOL;
        echo "Contenido: " . $response->getContent() . PHP_EOL;
    } else {
        $data = json_decode($response->getContent(), true);
        
        if (json_last_error() !== JSON_ERROR_NONE) {
            echo "ERROR JSON: " . json_last_error_msg() . PHP_EOL;
            echo "Raw content (first 500 chars): " . substr($response->getContent(), 0, 500) . PHP_EOL;
        } else {
            echo "Éxito JSON decode." . PHP_EOL;
            echo "Success flag: " . ($data['success'] ? 'TRUE' : 'FALSE') . PHP_EOL;
            $numItems = count($data['data']);
            echo "Items retornados: $numItems" . PHP_EOL;
            
            if ($numItems > 0) {
                $first = $data['data'][0];
                echo "Primer paciente: " . $first['nombre'] . " " . $first['apellido'] . " (ID: " . $first['id'] . ")" . PHP_EOL;
            } else {
                echo "¡ALERTA! El array 'data' está vacío, aunque hay pacientes en DB." . PHP_EOL;
            }
        }
    }

} catch (\Exception $e) {
    echo "EXCEPCIÓN CRÍTICA: " . $e->getMessage() . PHP_EOL;
    echo $e->getTraceAsString() . PHP_EOL;
}
