<?php
// Cargar Laravel
require __DIR__.'/vendor/autoload.php';
$app = require __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "1. Buscando usuario admin...\n";
$user = \App\Models\Usuario::where('email', 'admin@cibertronia.com')->first();

if (!$user) {
    echo "ERROR: Usuario no encontrado.\n";
    exit(1);
}
echo "Usuario encontrado: ID {$user->id} ({$user->email})\n";

echo "2. Creando token...\n";
$token = $user->createToken('debug_token')->plainTextToken;
echo "Token generado: " . substr($token, 0, 10) . "...\n";

echo "3. Probando autenticación manual con Sanctum...\n";
// Simular request
$request = \Illuminate\Http\Request::create('/api/user', 'GET');
$request->headers->set('Authorization', 'Bearer ' . $token);
$request->headers->set('Accept', 'application/json');

try {
    // Intentar autenticar usando el guard de sanctum
    $guard = auth('sanctum');
    
    // Forzar validación
    if ($guard->check()) {
        echo "✅ AUTENTICACIÓN EXITOSA. Usuario autenticado: " . $guard->user()->email . "\n";
    } else {
        echo "❌ FALLÓ LA AUTENTICACIÓN. El token no fue aceptado.\n";
        
        // Diagnóstico adicional
        echo "Diagnóstico de configuración auth.php:\n";
        $config = config('auth.providers.users');
        print_r($config);
    }
} catch (Exception $e) {
    echo "Excepción: " . $e->getMessage() . "\n";
}
