<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$ids = [1];

foreach ($ids as $id) {
    $paciente = App\Models\Paciente::with('examen')->find($id);
    if ($paciente && $paciente->examen) {
        echo "Examen ID: " . $paciente->examen->id . "\n";
        echo "Nombre: " . $paciente->examen->nombre . "\n";
        echo "Descripcion: " . $paciente->examen->descripcion . "\n";
        
        // Check for validity
        echo "Nombre valid: " . (mb_check_encoding($paciente->examen->nombre, 'UTF-8') ? 'YES' : 'NO') . "\n";
        echo "Descripcion valid: " . (mb_check_encoding($paciente->examen->descripcion, 'UTF-8') ? 'YES' : 'NO') . "\n";
        
        // Try to fix
        $fixed = mb_convert_encoding($paciente->examen->descripcion, 'UTF-8', 'UTF-8');
        echo "Fixed Desc: " . $fixed . "\n";
    }
}
