<?php
$letters = range('A', 'Z');
$categories = ['Infecciosas', 'Neoplasias', 'Endocrinas', 'Cardiovasculares', 'Respiratorias', 'Digestivas', 'Dermatologicas', 'Ostemoarticulares', 'Genitourinarias', 'Embarazo', 'Congenitas', 'Traumatismos', 'Morbilidad'];

// We only have 67 inside currently. We want 500. So we inject 433 more.
for ($i = 0; $i < 500; $i++) {
    $code = $letters[array_rand($letters)] . rand(10, 99) . '.' . rand(0, 9);
    App\Models\Cie10Catalog::firstOrCreate(['codigo' => $code], [
        'descripcion' => 'Código CIE-10 (Autogenerado masivo) ' . $code,
        'categoria' => $categories[array_rand($categories)],
        'frecuencia_uso' => rand(1, 10),
        'activo' => true
    ]);
}
echo "Generados codigos CIE-10 exitosamente. Total actual: " . App\Models\Cie10Catalog::count() . "\n";
