import axios from 'axios';

// Crear instancia de axios para el portal del paciente
const apiPaciente = axios.create({
    baseURL: 'http://localhost:8000/api',
    headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json',
    },
});

// Interceptor para agregar token y paciente_id
apiPaciente.interceptors.request.use(
    (config) => {
        const token = localStorage.getItem('paciente_token');
        const pacienteId = localStorage.getItem('paciente_id');
        
        if (token) {
            config.headers.Authorization = `Bearer ${token}`;
        }
        
        if (pacienteId) {
            config.headers['X-Paciente-Id'] = pacienteId;
        }
        
        return config;
    },
    (error) => {
        return Promise.reject(error);
    }
);

// Interceptor para manejar errores
apiPaciente.interceptors.response.use(
    (response) => response,
    (error) => {
        if (error.response?.status === 401) {
            localStorage.removeItem('paciente_token');
            localStorage.removeItem('paciente');
            localStorage.removeItem('paciente_id');
            window.location.href = '/paciente/login';
        }
        return Promise.reject(error);
    }
);

export default apiPaciente;
