import axios from 'axios';

// Configuración global de axios
window.axios = axios;

// Base URL del API (Laravel)
window.axios.defaults.baseURL = '/api';

// Headers comunes
window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
window.axios.defaults.headers.common['Accept'] = 'application/json';
window.axios.defaults.headers.common['Content-Type'] = 'application/json';

// Habilitar envío de cookies para CSRF
window.axios.defaults.withCredentials = true;

// Interceptor para agregar token de autorización
window.axios.interceptors.request.use(
    (config) => {
        // Si es una petición del portal del paciente, no agregar auth_token del admin
        const url = config.url || '';
        const isPacienteRoute = url.includes('/paciente/');
        
        if (!isPacienteRoute) {
            // Solo para rutas de administrador, agregar token
            const token = localStorage.getItem('token');
            if (token) {
                config.headers.Authorization = `Bearer ${token}`;
            }
        }
        return config;
    },
    (error) => {
        return Promise.reject(error);
    }
);

// Interceptor para manejar respuestas
window.axios.interceptors.response.use(
    (response) => response,
    (error) => {
        // Si hay error 401 (no autenticado)
        if (error.response && error.response.status === 401) {
            const url = error.config?.url || '';
            const isPacienteRoute = url.includes('/paciente/');
            
            if (isPacienteRoute) {
                // Si es ruta del paciente, redirigir al login del paciente
                localStorage.removeItem('paciente_token');
                localStorage.removeItem('paciente');
                localStorage.removeItem('paciente_id');
                window.location.href = '/paciente/login';
            } else {
                // Si es ruta del admin, redirigir al login del admin
                localStorage.removeItem('token');
                localStorage.removeItem('user');
                window.location.href = '/login';
            }
        }
        return Promise.reject(error);
    }
);

export default axios;
