

// Mock data – replace with real API calls later
const mockAlerts = [
    { id: 1, type: 'warning', message: '⚠️ 2 dominios vencen en 3 días', link: '/app/services/domains' },
    { id: 2, type: 'danger', message: '❌ Factura #INV-2026-001 vencida', link: '/app/billing' },
    { id: 3, type: 'info', message: '📅 Renovación próxima: Hosting Pro', link: '/app/calendar' },
];

export default function NotificationSummary() {
    return (
        <div className="card" style={{ background: 'var(--bg-card)', padding: '1rem' }}>
            <h2 className="page-title" style={{ marginBottom: '0.75rem' }}>Resumen de Alertas</h2>
            <ul style={{ listStyle: 'none', margin: 0, padding: 0 }}>
                {mockAlerts.map(alert => (
                    <li key={alert.id} style={{ marginBottom: '0.5rem' }}>
                        <a href={alert.link} style={{ color: 'var(--text-primary)', textDecoration: 'none', display: 'flex', alignItems: 'center', gap: '0.5rem' }}>
                            <span>{alert.type === 'warning' ? '⚠️' : alert.type === 'danger' ? '❌' : 'ℹ️'}</span>
                            <span>{alert.message}</span>
                        </a>
                    </li>
                ))}
            </ul>
        </div>
    );
}
