import { useState, useEffect } from 'react';
import axios from 'axios';
import PageHeader from '../../components/PageHeader';

/**
 * 🎨 MÓDULO: HOSTING - CALENDARIO
 * 
 * ✅ ESTILO ACTUALIZADO
 */

export default function HostingCalendar() {
    const [events, setEvents] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);
    const [dateRange, setDateRange] = useState({
        from: new Date().toISOString().split('T')[0],
        to: new Date(Date.now() + 30 * 24 * 60 * 60 * 1000).toISOString().split('T')[0]
    });

    useEffect(() => {
        fetchEvents();
    }, [dateRange]);

    const fetchEvents = async () => {
        try {
            const res = await axios.get('/api/hosting/calendar', { params: dateRange });
            setEvents(res.data);
        } catch (error) {
            console.error(error);
        } finally {
            setLoading(false);
        }
    };

    if (loading) return <div className="p-8 text-center">Cargando calendario...</div>;

    return (
        <div className="animate-fadeIn">
            <PageHeader
                title="Calendario de Hosting"
                subtitle="Renovaciones y mantenimientos programados"
            />

            <div className="card">
                <h3 className="text-lg font-bold mb-4">Próximos Eventos</h3>
                <div className="space-y-3">
                    {events.length === 0 ? (
                        <p className="text-slate-500">No hay eventos próximos</p>
                    ) : (
                        events.map((event, idx) => (
                            <div key={idx} className="p-4 bg-slate-800/50 rounded border border-slate-700">
                                <div className="flex justify-between items-center">
                                    <div>
                                        <div className="font-bold text-white">{event.title}</div>
                                        <div className="text-sm text-slate-400">{event.start}</div>
                                    </div>
                                    <span className={`badge ${event.type === 'renewal' ? 'badge-warning' : 'badge-primary'}`}>
                                        {event.type}
                                    </span>
                                </div>
                            </div>
                        ))
                    )}
                </div>
            </div>
        </div>
    );
}
