import React, { useEffect, useState } from 'react';
import axios from 'axios';
import PageHeader from '../../components/PageHeader';

export default function SoftwareDevPlans() {
    const [plans, setPlans] = useState([]);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        loadPlans();
    }, []);

    const loadPlans = async () => {
        try {
            const res = await axios.get('/api/software-dev/plans');
            setPlans(res.data);
        } catch (error) {
            console.error('Error cargando planes:', error);
        } finally {
            setLoading(false);
        }
    };

    return (
        <div className="animate-fade-in space-y-6">
            <PageHeader
                title="Planes de Software Desktop"
                subtitle="Configuración de esquemas de licenciamiento y precios"
                actions={
                    <button className="btn btn-primary" onClick={() => alert('Próximamente: Modal Crear Plan')}>
                        + Nuevo Plan
                    </button>
                }
            />

            <div className="card overflow-hidden">
                <div className="table-container">
                    <table className="table">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Plataforma</th>
                                <th>Modelo</th>
                                <th>Precio Base</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            {loading ? (
                                <tr>
                                    <td colSpan={6} className="text-center py-8 text-gray-500">Cargando...</td>
                                </tr>
                            ) : plans.length === 0 ? (
                                <tr>
                                    <td colSpan={6} className="text-center py-8 text-gray-500">No hay planes configurados.</td>
                                </tr>
                            ) : (
                                plans.map((plan: any) => (
                                    <tr key={plan.id}>
                                        <td className="font-medium">{plan.name}</td>
                                        <td>
                                            <span className="badge bg-gray-100 text-gray-700 dark:bg-gray-800 dark:text-gray-300">
                                                {plan.platform}
                                            </span>
                                        </td>
                                        <td>{plan.licensing_model} / {plan.pricing_model}</td>
                                        <td>{plan.currency} {plan.base_price}</td>
                                        <td>
                                            <span className={`badge ${plan.is_active ? 'badge-success' : 'badge-danger'}`}>
                                                {plan.is_active ? 'Activo' : 'Inactivo'}
                                            </span>
                                        </td>
                                        <td>
                                            <button className="text-blue-600 hover:text-blue-800 mr-2">Editar</button>
                                        </td>
                                    </tr>
                                ))
                            )}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    );
}
