import React from 'react';
import { useTheme } from '../../context/ThemeContext';

export default function Facturacion() {
    const { isDarkMode } = useTheme();

    return (
        <div className="space-y-6">
            <div>
                <h1 className={`text-3xl font-bold ${isDarkMode ? 'text-white' : 'text-gray-900'}`}>
                    💳 Facturación
                </h1>
                <p className={`${isDarkMode ? 'text-gray-400' : 'text-gray-600'} mt-1`}>
                    Gestión de pagos y facturación de servicios
                </p>
            </div>

            <div className={`rounded-2xl p-8 ${isDarkMode ? 'bg-gray-800/50 border border-gray-700/50' : 'bg-white border border-gray-200'} shadow-lg text-center`}>
                <div className="text-6xl mb-4">💳</div>
                <h2 className={`text-2xl font-bold ${isDarkMode ? 'text-white' : 'text-gray-900'} mb-2`}>
                    Sistema de Facturación
                </h2>
                <p className={`${isDarkMode ? 'text-gray-400' : 'text-gray-600'}`}>
                    Control de pagos, facturas y reportes financieros
                </p>
            </div>
        </div>
    );
}
