export interface Cie10 {
    id: number;
    codigo: string;
    descripcion: string;
    categoria?: string;
}

export interface SoapNotes {
    subjetivo: string;
    objetivo: string;
    analisis: string;
    plan: string;
}

export interface ExamenFisico {
    sistema: string;
    hallazgos: string;
}

export interface Auditoria {
    creado_por: number;
    creado_fecha: string;
    ip?: string;
}

export interface HistoriaArchivo {
    id: number;
    nombre_original: string;
    ruta_archivo: string;
    mime_type: string;
    descripcion?: string;
    created_at: string;
}

export interface HistoriaEvolucion {
    id: number;
    fecha_evolucion: string;
    notas_soap: SoapNotes | null;
    estado_paciente: 'estable' | 'mejorando' | 'empeorando' | 'critico' | 'dado_de_alta';
    medico?: {
        id: number;
        nombre: string;
        apellido: string;
    };
    observaciones?: string;
}

export interface MedicamentoReceta {
    id: number;
    receta_id: number;
    nombre_medicamento: string;
    dosis: string;
    via_administracion: string;
    frecuencia: string;
    duracion_dias: number;
    cantidad_total: number;
    instrucciones_especiales?: string;
}

export interface RecetaMedica {
    id: number;
    fecha_emision: string;
    instrucciones_generales?: string;
    medicamentos?: MedicamentoReceta[];
}

export interface HistoriaClinica {
    id: number;
    cita_id: number;
    paciente_id: number;
    medico_id: number;
    fecha_consulta: string;

    // Campos tradicionales
    motivo_consulta: string;
    presion_arterial?: string;
    temperatura?: number;
    peso?: number;
    altura?: number;
    imc?: number;
    sat_oxigeno?: number;

    // Campos Fase 2 - CIE-10 / SOAP
    cie10_id?: number;
    cie10_codigo_texto?: string;
    tipo_diagnostico?: 'presuntivo' | 'definitivo';
    notas_soap?: SoapNotes;
    examen_fisico?: ExamenFisico[];

    // Relaciones
    medico?: {
        id: number;
        nombre: string;
        apellido: string;
        especialidad?: string;
    };
    cie10?: Cie10;
    archivos?: HistoriaArchivo[];
    evoluciones?: HistoriaEvolucion[];
    recetasMedicas?: RecetaMedica[];
    examenesMedicos?: any[];

    bloqueada_para_edicion?: boolean;
    created_at: string;
    updated_at: string;
}
