<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\EstudioController;

/*
|--------------------------------------------------------------------------
| Web Routes - Cibertronia Salud
|--------------------------------------------------------------------------
*/

// Ruta de login (requerida por el middleware de auth, redirige al SPA)
Route::get('/login', function () {
    return view('app');
})->name('login');

// SOLUCIÓN 3: Endpoint público para estudios (lectura solamente)
// Esto permite que el selector funcione incluso si hay problemas de autenticación
Route::get('/api/estudios-publicos', [EstudioController::class, 'indexPublico']);

// Ruta principal - carga la aplicación React SPA
Route::get('/', function () {
    return view('app');
});

// Todas las demás rutas también cargan React (SPA routing)
Route::get('/{any}', function () {
    return view('app');
})->where('any', '.*');
